/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class contractApproveController {
    private static final Logger contractLogger;

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_service")
    public ResponseObject approveService(UserContext uc, String approveDate, String approveIds) throws SQLException {
        if (StringUtils.isBlank((CharSequence)approveDate) || StringUtils.isBlank((CharSequence)approveIds)) {
            return ResponseObject.newErrResponse((String)"\u53c2\u6570\u9519\u8bef");
        }
        contractService.getInstance().postRecurringServices(uc, approveDate, approveIds);
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_milestone")
    public ResponseObject approveMilestone(UserContext uc, String approveDate, String approveIds) throws SQLException {
        if (StringUtils.isBlank((CharSequence)approveDate) || StringUtils.isBlank((CharSequence)approveIds)) {
            return ResponseObject.newErrResponse((String)"\u53c2\u6570\u9519\u8bef");
        }
        contractService.getInstance().postMilestone(uc, approveDate, approveIds);
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_updateExtendedPrice")
    public ResponseObject updateExtendedPrice(UserContext uc, Double periodPrice, String id, int type) throws SQLException {
        if (type != 86 && type == 87) {
            BO ccBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", id);
            if (ccBO != null) {
                ccBO.set("ADJUST_SETUP_FEE", (Object)periodPrice);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", ccBO);
            } else {
                BO ccsaBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", id);
                if (ccsaBO != null) {
                    ccsaBO.set("ADJUST_PRORATED_PRICE_CHANGE", (Object)periodPrice);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", ccsaBO);
                } else {
                    BO ccspBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", id);
                    if (ccspBO != null) {
                        ccspBO.set("PERIOD_ADJUSTED_PRICE", (Object)periodPrice);
                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", ccspBO);
                    }
                }
            }
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_restoreInitialPrice")
    public ResponseObject restoreInitialPrice(UserContext uc, String ids, int type) throws SQLException {
        if (type != 86 && type == 87) {
            for (String id : ids.split(",")) {
                BO ccBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", id);
                if (ccBO != null) {
                    ccBO.set("ADJUST_SETUP_FEE", ccBO.get("SETUP_FEE"));
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", ccBO);
                    continue;
                }
                BO ccsaBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", id);
                if (ccsaBO != null) {
                    ccsaBO.set("ADJUST_PRORATED_PRICE_CHANGE", ccsaBO.get("PRORATED_PRICE_CHANGE"));
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", ccsaBO);
                    continue;
                }
                BO ccspBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", id);
                if (ccspBO == null) continue;
                ccspBO.set("PERIOD_ADJUSTED_PRICE", ccspBO.get("PERIOD_PRICE"));
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", ccspBO);
            }
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_cost")
    public ResponseObject cost(UserContext uc, String approveDate, String approveIds) throws SQLException {
        boolean result = contractService.getInstance().postCost(uc, approveDate, approveIds);
        return result ? ResponseObject.newOkResponse() : ResponseObject.newErrResponse((String)"\u5ba1\u6279\u5931\u8d25");
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_recurring_services")
    public ResponseObject revokeRecurringServices(UserContext uc, String ids) throws SQLException {
        String result = contractService.getInstance().revokeRecurringServices(uc, ids);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseObject.newErrResponse((String)result);
        }
        contractLogger.info("\u64a4\u9500\u5b9a\u671f\u670d\u52a1\u6210\u529f");
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_milestones")
    public ResponseObject revokeMilestones(UserContext uc, String ids) throws SQLException {
        String result = contractService.getInstance().revokeMilestones(uc, ids);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseObject.newErrResponse((String)result);
        }
        contractLogger.info("\u64a4\u9500\u91cc\u7a0b\u7891\u6210\u529f");
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_cost")
    public ResponseObject revokeCost(UserContext uc, String ids) throws SQLException {
        String result = contractService.getInstance().revokeCost(uc, ids);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseObject.newErrResponse((String)result);
        }
        contractLogger.info("\u64a4\u9500\u5408\u540c\u6210\u672c\u6210\u529f");
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.modify_taxRate")
    public ResponseObject modifyTaxRate(UserContext uc, String id) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
        String account_id = bo.getString("ACCOUNT_ID");
        String extended_price = bo.getString("EXTENDED_PRICE");
        String tax_category_id = bo.getString("TAX_CATEGORY_ID");
        String effective_tax_rate = bo.getString("EFFECTIVE_TAX_RATE");
        String tax_dollars = bo.getString("TAX_DOLLARS");
        List effectiveTaxRateList = DBSql.getMaps((String)"select tax_cate_id as taxCateId,total_effective_tax_rate as effectiveTaxRate from bo_eu_dnd_tax_region_cate where tax_region_id IN (select tax_region_id from bo_eu_dncrm_account where id=?)", (Object[])new Object[]{account_id});
        List taxCateList = DBSql.getMaps((String)"SELECT oid,NAME FROM bo_eu_dnd_general WHERE general_table_id=44 AND CLOSED=0 AND ORGID=? AND oid in(select tax_cate_id from bo_eu_dnd_tax_region_cate where tax_region_id in (select tax_region_id from bo_eu_dncrm_account where id=?))", (Object[])new Object[]{uc.getCompanyModel().getId(), account_id});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taxCateList", taxCateList);
        map.put("effectiveTaxRateList", effectiveTaxRateList);
        map.put("taxCateId", tax_category_id);
        map.put("effectiveTaxRate", effective_tax_rate);
        map.put("taxDollars", tax_dollars);
        map.put("extendedPrice", extended_price);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(map);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.modify_taxRate_save")
    public ResponseObject modifyTaxRateSave(UserContext uc, String id, String taxCateId, String effectiveTaxRate, String taxDollars) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
        bo.set("TAX_CATEGORY_ID", (Object)taxCateId);
        bo.set("tax_category_name", (Object)DBSql.getString((String)"SELECT NAME FROM bo_eu_dnd_general WHERE general_table_id=44 AND oid=?", (Object[])new Object[]{taxCateId}));
        bo.set("EFFECTIVE_TAX_RATE", (Object)effectiveTaxRate);
        bo.set("TAX_DOLLARS", (Object)taxDollars);
        SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo);
        return ResponseObject.newOkResponse();
    }

    static {
        SDK.getLogAPI();
        contractLogger = LogAPI.getLogger(contractApproveController.class);
    }
}

