/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.utils;

import com.alibaba.nacos.api.utils.StringUtils;
import com.google.common.base.Optional;
import java.math.BigDecimal;

public class BigDecimalUtil {
    private BigDecimalUtil() {
    }

    public static String add(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).toPlainString();
    }

    public static String sub(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).toPlainString();
    }

    public static String mul(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).toPlainString();
    }

    public static String div(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1) || StringUtils.isBlank((CharSequence)v2) || v2.equals("0")) {
            return "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, 2, 4).toPlainString();
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, 2, 4).doubleValue();
    }

    public static String div(String v1, String v2, int decimalDigits) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        BigDecimal noZeros = b1.divide(b2, decimalDigits, 4).stripTrailingZeros();
        String result = noZeros.toPlainString();
        return result;
    }

    public static double round(double d, int len) {
        BigDecimal b1 = new BigDecimal(d);
        BigDecimal b2 = new BigDecimal(1);
        return b1.divide(b2, len, 4).doubleValue();
    }

    public static BigDecimal safeAdd(BigDecimal b1, BigDecimal ... bn) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        if (bn != null) {
            BigDecimal[] bigDecimalArray = bn;
            int n = bn.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal b = bigDecimalArray[n2];
                b1 = b1.add(b == null ? BigDecimal.ZERO : b);
                ++n2;
            }
        }
        return b1;
    }

    public static Integer safeAdd(Integer b1, Integer ... bn) {
        if (b1 == null) {
            b1 = 0;
        }
        Integer r = b1;
        if (bn != null) {
            Integer[] integerArray = bn;
            int n = bn.length;
            int n2 = 0;
            while (n2 < n) {
                Integer b = integerArray[n2];
                r = r + (Integer)Optional.fromNullable((Object)b).or((Object)0);
                ++n2;
            }
        }
        return r > 0 ? r : 0;
    }

    public static BigDecimal safeSubtract(BigDecimal b1, BigDecimal ... bn) {
        return BigDecimalUtil.safeSubtract(true, b1, bn);
    }

    public static BigDecimal safeSubtract(Boolean isZero, BigDecimal b1, BigDecimal ... bn) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        BigDecimal r = b1;
        if (bn != null) {
            BigDecimal[] bigDecimalArray = bn;
            int n = bn.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal b = bigDecimalArray[n2];
                r = r.subtract(b == null ? BigDecimal.ZERO : b);
                ++n2;
            }
        }
        return isZero.booleanValue() ? (r.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : r) : r;
    }

    public static Integer safeSubtract(Integer b1, Integer ... bn) {
        if (b1 == null) {
            b1 = 0;
        }
        Integer r = b1;
        if (bn != null) {
            Integer[] integerArray = bn;
            int n = bn.length;
            int n2 = 0;
            while (n2 < n) {
                Integer b = integerArray[n2];
                r = r - (Integer)Optional.fromNullable((Object)b).or((Object)0);
                ++n2;
            }
        }
        return r != null && r > 0 ? r : 0;
    }

    public static <T extends Number> BigDecimal safeMultiply(T b1, T b2) {
        if (b1 == null || b2 == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(b1.doubleValue()).multiply(BigDecimal.valueOf(b2.doubleValue())).setScale(2, 4);
    }

    public static <T extends Number> BigDecimal safeDivide(T b1, T b2) {
        return BigDecimalUtil.safeDivide(b1, b2, BigDecimal.ZERO);
    }

    public static <T extends Number> BigDecimal safeDivide(T b1, T b2, BigDecimal defaultValue) {
        if (b1 == null || b2 == null) {
            return defaultValue;
        }
        try {
            return BigDecimal.valueOf(b1.doubleValue()).divide(BigDecimal.valueOf(b2.doubleValue()), 2, 4);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

