/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilImage;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.DCAPI;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNetwork
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateNetwork.class);

    @Meta(parameter={"name: 'networkId', required: false, desc: '\u540c\u4e8b\u5708ID'", "name: 'networkName', required: true, desc: '\u540c\u4e8b\u5708\u540d'", "name: 'networkLogo', required: false, desc: 'LOGO'", "name: 'networkDesc', required: false, desc: '\u540c\u4e8b\u5708\u63cf\u8ff0'", "name: 'createUser', required: false, desc: '\u521b\u5efa\u4ebauid'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            UserContext me = null;
            if (params.containsKey("createUser")) {
                String uid = params.get("createUser").toString();
                me = UserContext.fromUID((String)uid);
            }
            if (params.containsKey("sid")) {
                String sid = params.get("sid").toString();
                me = UserContext.fromSessionId((String)sid);
            }
            String networkId = params.get("networkId") == null ? "" : params.get("networkId").toString();
            String networkName = params.get("networkName").toString();
            String networkLogo = params.get("networkLogo") == null ? "" : params.get("networkLogo").toString();
            String networkDesc = params.get("networkDesc") == null ? "" : params.get("networkDesc").toString();
            String result = "";
            NetworkWeb web = new NetworkWeb(me);
            NetworkModel model = new NetworkModel();
            model.setNetworkDesc(networkDesc);
            model.setNetworkName(networkName);
            if (UtilString.isEmpty((String)networkId)) {
                model.setId(UUIDGener.getUUID());
                result = web.saveNetwork(model);
            } else {
                NetworkModel networkModel = NetworkCache.getModel(networkId);
                if (networkModel == null) {
                    model.setId(networkId);
                    result = web.saveNetwork(model);
                } else {
                    networkModel.setNetworkName(networkName);
                    networkModel.setNetworkDesc(networkDesc);
                    result = web.updateNetwork(networkModel);
                }
            }
            if (!UtilString.isEmpty((String)networkLogo)) {
                DCAPI dcApi = SDK.getDCAPI();
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((byte[])networkLogo.getBytes()));
                DataInputStream dataInputStream = new DataInputStream(bais);
                DCContext dc = new DCContext(me, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!network-logo"), "com.actionsoft.apps.network", "network", model.getId(), "logo_big.jpg");
                dcApi.write((InputStream)dataInputStream, dc);
                UtilImage.zoomCut((String)dc.getFilePath(), (String)(dc.getPath() + "logo.jpg"), (int)120, (int)120);
            }
            ro.put("networkInfo", (Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }
}

