/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkAppListModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAppListDao
extends DaoObject<NetworkAppListModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkAppListDao.class);

    public List<NetworkAppListModel> loadNetworkAppListOfCache() {
        List<NetworkAppListModel> list = new ArrayList<NetworkAppListModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_LIST");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public List<NetworkAppListModel> findAppListByNetwork(String networkId) throws SQLException {
        ArrayList<NetworkAppListModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_LIST").append(" T WHERE T.NETWORKID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[]{networkId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public List<NetworkAppListModel> findAppListByAppId(String appId) throws SQLException {
        ArrayList<NetworkAppListModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT TE.* FROM ").append("APP_ACT_NETWORK_APP_LIST").append(" T WHERE T.APPID = ?  ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[]{appId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkAppListModel getAppListById(String id) throws SQLException {
        NetworkAppListModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_LIST").append(" T WHERE T.ID = ? ");
            model = (NetworkAppListModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public List<NetworkAppListModel> getAppListById(String networkId, String appId) throws SQLException {
        ArrayList<NetworkAppListModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT T.* FROM ").append("APP_ACT_NETWORK_APP_LIST").append(" T WHERE T.NETWORKID = ? AND T.APPID = ?  ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[]{networkId, appId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public boolean deleteNetworkAppListById(String id) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append("APP_ACT_NETWORK_APP_ACCESS").append(" where id=:id");
        params.put("id", id);
        return DBSql.update((String)sql.toString(), params) > 0;
    }

    public List<NetworkAppListModel> loadNetworkAppList() throws SQLException {
        LinkedList<NetworkAppListModel> list = new LinkedList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append("APP_ACT_NETWORK_APP_LIST").append(" order by id desc ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkAppListModel getNoteworkAppListById(String id) throws SQLException {
        NetworkAppListModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append("APP_ACT_NETWORK_APP_LIST").append(" where id = ? ");
            model = (NetworkAppListModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkAppListModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public int insert(NetworkAppListModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("NETWORKID", model.getNetworkId());
        paramsMap.put("APPID", model.getAppId());
        paramsMap.put("APPTYPE", model.getAppType());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        int result = DBSql.update((String)DBSql.getInsertStatement((String)"APP_ACT_NETWORK_APP_LIST", paramsMap), paramsMap);
        return result;
    }

    public String entityName() {
        return "APP_ACT_NETWORK_APP_LIST";
    }

    public RowMapper<NetworkAppListModel> rowMapper() {
        return null;
    }

    public int update(NetworkAppListModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("NETWORKID", model.getNetworkId());
        paramsMap.put("APPID", model.getAppId());
        paramsMap.put("APPTYPE", model.getAppType());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        return super.update((Object)model.getId(), paramsMap);
    }

    private static class NetworkAppListModelRowMapper
    implements RowMapper<NetworkAppListModel> {
        private NetworkAppListModelRowMapper() {
        }

        public NetworkAppListModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkAppListModel model = new NetworkAppListModel();
            model.setId(rs.getString("ID"));
            model.setNetworkId(rs.getString("NETWORKID"));
            model.setAppId(rs.getString("APPID"));
            model.setAppType(rs.getString("APPTYPE"));
            model.setLastActive(rs.getTimestamp("LASTACTIVE"));
            return model;
        }
    }
}

