/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.notification;

import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.client.notification.NotificationMessageFormatter;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;

public class NetworkDynamicFormatter
implements NotificationMessageFormatter {
    public ResponseObject parser(UserContext user, String content) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext appContext = SDK.getAppAPI().getAppContext("com.actionsoft.apps.network");
        String appName = "\u540c\u4e8b\u5708";
        if (appContext != null) {
            appName = appContext.getName();
        }
        if (!NetworkDataUtil.isJson(content)) {
            ro.put("content", (Object)content);
            return ro;
        }
        JSONObject json = JSONObject.parseObject((String)content);
        if (json.get((Object)"data") == null) {
            ro.put("content", (Object)content);
            ro.put("buttons", new HashMap());
            return ro;
        }
        String data = json.getString("data");
        data = data.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        String streamId = json.getString("streamId");
        String streamCommentId = json.get((Object)"streamCommentId") == null ? "" : json.getString("streamCommentId");
        boolean isStreamAnonymous = NetworkDataUtil.isAnonymousByStreamId(streamId);
        boolean isCommentAnonymous = NetworkDataUtil.isAnonymousByCommentId(streamCommentId);
        ro.put("content", (Object)data);
        ArrayList buttons = new ArrayList();
        HashMap<String, Object> button1 = new HashMap<String, Object>();
        button1.put("name", "\u67e5\u770b\u8be6\u60c5");
        if (user.isMobileClient()) {
            String userAgent = DispatcherRequest.getContext().getUserAgent();
            if (userAgent.contains("Android")) {
                button1.put("action", "networkSchema:streamId=" + streamId);
                ro.put("mobileAppId", (Object)"com.actionsoft.apps.network.android");
            } else if (userAgent.contains("iPhone") || userAgent.contains("AWSMobilePortalPhone")) {
                button1.put("action", "com.actionsoft.apps.network.ios://streamId=" + streamId);
                ro.put("mobileAppId", (Object)"com.actionsoft.apps.network.ios");
            }
            button1.put("target", "app");
            button1.put("actionError", "\u8bf7\u5b89\u88c5" + appName + "\u5e94\u7528");
        } else {
            button1.put("action", SDK.getConfAPI().getPortalUrl() + "/r/w?sid=@sid&cmd=com.actionsoft.apps.network_home&streamId=" + streamId + "&streamCommentId=" + streamCommentId);
            button1.put("target", "mainFrame");
        }
        button1.put("functionId", "network.dynamic");
        button1.put("functionName", appName);
        button1.put("color", "blue");
        buttons.add(button1);
        ro.put("buttons", buttons);
        ro.put("isStreamAnonymous", (Object)(isStreamAnonymous ? "true" : "false"));
        ro.put("isCommentAnonymous", (Object)(isCommentAnonymous ? "true" : "false"));
        return ro;
    }
}

