/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.dao.NetworkAppListDao;
import com.actionsoft.apps.network.model.NetworkAppListModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class NetworkAppListCache
extends Cache<String, NetworkAppListModel> {
    public NetworkAppListCache(CachePluginProfile profile) {
        super(profile);
    }

    public static void putModel(NetworkAppListModel model) {
        NetworkAppListModel old = NetworkAppListCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkAppListDao().insert(model) : new NetworkAppListDao().update(model);
        if (result == 1) {
            NetworkAppListCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkAppListModel getModel(String id) {
        return (NetworkAppListModel)((Object)NetworkAppListCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkAppListDao().delete(id);
        if (result == 1) {
            NetworkAppListCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static List<NetworkAppListModel> loadAllNetwork() {
        Iterator iter = NetworkAppListCache.getCache().iterator();
        NetworkAppListCache.getCache();
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkAppListModel> loadAllNetwork(String networkId) {
        List<NetworkAppListModel> lists = NetworkAppListCache.loadAllNetwork();
        ArrayList<NetworkAppListModel> networkAppList = new ArrayList<NetworkAppListModel>();
        if (lists.size() > 0) {
            for (NetworkAppListModel model : lists) {
                if (!model.getNetworkId().equals(networkId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public static List<NetworkAppListModel> loadAllNetworkByApp(String appId) {
        List<NetworkAppListModel> lists = NetworkAppListCache.loadAllNetwork();
        ArrayList<NetworkAppListModel> networkAppList = new ArrayList<NetworkAppListModel>();
        if (lists.size() > 0) {
            for (NetworkAppListModel model : lists) {
                if (!model.getAppId().equals(appId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public static List<NetworkAppListModel> loadAllNetwork(String appId, String networkId) {
        List<NetworkAppListModel> lists = NetworkAppListCache.loadAllNetwork();
        ArrayList<NetworkAppListModel> networkAppList = new ArrayList<NetworkAppListModel>();
        if (lists.size() > 0) {
            for (NetworkAppListModel model : lists) {
                if (!model.getAppId().equals(appId) || !model.getNetworkId().equals(networkId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public void load() {
        List<NetworkAppListModel> list = new NetworkAppListDao().loadNetworkAppListOfCache();
        for (NetworkAppListModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u5de5\u4f5c\u7f51\u7edc\u5e94\u7528 [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkAppListCache getCache() {
        return (NetworkAppListCache)CacheManager.getCache(NetworkAppListCache.class);
    }
}

