/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.dao.NetworkAppAccessDao;
import com.actionsoft.apps.network.model.NetworkAppAccessModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class NetworkAppAccessCache
extends Cache<String, NetworkAppAccessModel> {
    public NetworkAppAccessCache(CachePluginProfile profile) {
        super(profile);
    }

    public static void putModel(NetworkAppAccessModel model) {
        NetworkAppAccessModel old = NetworkAppAccessCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkAppAccessDao().insert(model) : new NetworkAppAccessDao().update(model);
        if (result == 1) {
            NetworkAppAccessCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkAppAccessModel getModel(String id) {
        return (NetworkAppAccessModel)((Object)NetworkAppAccessCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkAppAccessDao().delete(id);
        if (result == 1) {
            NetworkAppAccessCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static List<NetworkAppAccessModel> loadAllNetworkAppAccess() {
        Iterator iter = NetworkAppAccessCache.getCache().iterator();
        NetworkAppAccessCache.getCache();
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkAppAccessModel> loadAllNetworkAppAccessByTeam(String teamId) {
        List<NetworkAppAccessModel> lists = NetworkAppAccessCache.loadAllNetworkAppAccess();
        ArrayList<NetworkAppAccessModel> networkAppList = new ArrayList<NetworkAppAccessModel>();
        if (lists.size() > 0) {
            for (NetworkAppAccessModel model : lists) {
                if (!model.getTeamId().equals(teamId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public static List<NetworkAppAccessModel> loadAllNetworkAppAccessByApp(String appId) {
        List<NetworkAppAccessModel> lists = NetworkAppAccessCache.loadAllNetworkAppAccess();
        ArrayList<NetworkAppAccessModel> networkAppList = new ArrayList<NetworkAppAccessModel>();
        if (lists.size() > 0) {
            for (NetworkAppAccessModel model : lists) {
                if (!model.getAppId().equals(appId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public static List<NetworkAppAccessModel> loadAllNetworkAppAccessByApp(String appId, String networkId) {
        List<NetworkAppAccessModel> lists = NetworkAppAccessCache.loadAllNetworkAppAccess();
        ArrayList<NetworkAppAccessModel> networkAppList = new ArrayList<NetworkAppAccessModel>();
        if (lists.size() > 0) {
            for (NetworkAppAccessModel model : lists) {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(model.getTeamId());
                if (!model.getAppId().equals(appId) || teamModel == null || !teamModel.getNetworkId().equals(networkId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public static List<NetworkAppAccessModel> loadAllNetworkAppAccessBy(String appId, String teamId) {
        List<NetworkAppAccessModel> lists = NetworkAppAccessCache.loadAllNetworkAppAccess();
        ArrayList<NetworkAppAccessModel> networkAppList = new ArrayList<NetworkAppAccessModel>();
        if (lists.size() > 0) {
            for (NetworkAppAccessModel model : lists) {
                if (!model.getAppId().equals(appId) || !model.getTeamId().equals(teamId)) continue;
                networkAppList.add(model);
            }
        }
        return networkAppList;
    }

    public static List<String> loadTeamIdsBy(String appId, String networkId) {
        List<NetworkAppAccessModel> lists = NetworkAppAccessCache.loadAllNetworkAppAccess();
        ArrayList<String> networkAppList = new ArrayList<String>();
        if (lists.size() > 0) {
            for (NetworkAppAccessModel model : lists) {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(model.getTeamId());
                if (!model.getAppId().equals(appId) || teamModel == null || !teamModel.getNetworkId().equals(networkId)) continue;
                networkAppList.add(model.getTeamId());
            }
        }
        return networkAppList;
    }

    public void load() {
        List<NetworkAppAccessModel> list = new NetworkAppAccessDao().loadNetworkAppAccessOfCache();
        for (NetworkAppAccessModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u5c0f\u7ec4\u5e94\u7528 [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkAppAccessCache getCache() {
        return (NetworkAppAccessCache)CacheManager.getCache(NetworkAppAccessCache.class);
    }
}

