/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UUIDGener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InviteMember
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(InviteMember.class);

    @Meta(parameter={"name: 'teamId', required: true, desc: '\u5c0f\u7ec4ID'", "name: 'userId', required: true, desc: '\u7528\u6237\u767b\u5f55\u8d26\u53f7\uff0c\u591a\u4eba\u4ee5\u9017\u53f7\u9694\u5f00'", "name: 'deviceType', required: false, desc: '\u8bbe\u5907\u7c7b\u578b\uff0c\u5e94\u7528\u4e8e\u624b\u673a\u5ba2\u6237\u7aef'", "name: 'isAgree', required: false, desc: '\u88ab\u9080\u8bf7\u4eba\u662f\u5426\u540c\u610f\uff0c\u540c\u610f\uff1atrue\uff0c\u4e0d\u540c\u610f\uff1afalse\u3002\u9ed8\u8ba4\u4e0d\u540c\u610f'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = params.get("sid").toString();
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String teamId = params.get("teamId").toString();
            String userId = params.get("userId").toString();
            String deviceType = params.get("deviceType") == null ? null : params.get("deviceType").toString();
            String isAgreeStr = params.get("isAgree") == null ? "false" : params.get("isAgree").toString();
            boolean isAgree = Boolean.parseBoolean(isAgreeStr);
            NetworkTeamMemberModel model = new NetworkTeamMemberModel();
            model.setId(UUIDGener.getUUID());
            model.setTeamId(teamId);
            model.setUserId(userId);
            model.setJoinType("1");
            model.setMemberType("2");
            model.setMemberStatus("0");
            model.setCreateUserId(ctx.getUID());
            model.setCreateUserName(ctx.getUserName());
            NetworkWeb web = new NetworkWeb(ctx);
            if (isAgree) {
                model.setMemberStatus("1");
                ro = web.saveTeamMemberData(ctx, model, deviceType);
            } else {
                ro = web.saveTeamMember(model, deviceType);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }
}

