/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dc;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.network.jod.JodTool;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCStoreUtil;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilImage;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFileProcessor
extends AbstFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFileProcessor.class);

    public boolean uploadReady(Map<String, Object> param) throws Exception {
        block35: {
            DCContext context = (DCContext)param.get("DCContext");
            File folder = new File(context.getPath());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            Object fileName = context.getFileName();
            context.setFileNameShow((String)fileName);
            String uuid = UUIDGener.getUUID();
            String postfix = "";
            int postfixIdx = ((String)fileName).lastIndexOf(".");
            if (postfixIdx != -1) {
                postfix = ((String)fileName).substring(postfixIdx, ((String)fileName).length());
            }
            fileName = uuid + postfix;
            context.setFileName((String)fileName);
            int fileSize = 0;
            if (context.getExtParams().containsKey("attr.fileLength")) {
                fileSize = Integer.parseInt(context.getExtParams().get("attr.fileLength").toString());
            }
            boolean readSize = false;
            File uploadFile = new File(folder, (String)fileName);
            if (param.containsKey("data")) {
                InputStream data = (InputStream)param.get("data");
                DCStoreUtil.write((DCContext)context, (InputStream)data);
            }
            if (param.containsKey("fileSize")) {
                fileSize = (Integer)param.get("fileSize");
            }
            context.setDCMessage("ok", "");
            context.getDCMessage().addAttr("fileName", (Object)context.getFileName());
            context.getDCMessage().addAttr("url", (Object)context.getDownloadURL());
            context.getDCMessage().addAttr("filePath", (Object)context.getPath());
            String fileNameShow = "";
            try {
                fileNameShow = URLEncoder.encode(context.getFileNameShow(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
            context.getDCMessage().addAttr("fileNameShow", (Object)fileNameShow);
            context.getDCMessage().addAttr("fileUUID", (Object)uuid);
            context.getDCMessage().addAttr("fileSize", (Object)fileSize);
            postfix = postfix.toLowerCase();
            if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(postfix.substring(1, postfix.length()) + ",")) {
                String origImgFileName = context.getFileName();
                String thumImgFileName = uuid + "_thum.jpg";
                try {
                    UtilImage.zoomCut((String)(context.getPath() + origImgFileName), (String)(context.getPath() + thumImgFileName), (int)130, (int)90);
                    DCContext dcCtx = new DCContext(context.getSession(), context.getDCProfile(), context.getAppId(), context.getGroupValue(), context.getFileValue(), origImgFileName);
                    context.getDCMessage().addAttr("origImgFilePath", (Object)dcCtx.getStremURL());
                    dcCtx.setFileName(thumImgFileName);
                    context.getDCMessage().addAttr("thumImgFilePath", (Object)dcCtx.getStremURL());
                }
                catch (Exception e) {
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
            } else if ("pdf".equals(postfix.substring(1, postfix.length()))) {
                ResponseObject ro = ResponseObject.newOkResponse();
                AppAPI appAPI = SDK.getAppAPI();
                JodTool jodTool = new JodTool();
                if (jodTool.isActive()) {
                    try {
                        String pdfFileName = uploadFile.getPath();
                        String origImgFileName = uuid + ".jpg";
                        String thumImgFileName = uuid + "_thum.jpg";
                        String sid = context.getSession().getSessionId();
                        String pdfFilePath = pdfFileName;
                        String origImgFilePath = context.getPath() + origImgFileName;
                        String thumImgFilePath = context.getPath() + thumImgFileName;
                        int thumWidth = 130;
                        int thumHeight = 90;
                        ro = jodTool.pdf2Image(sid, pdfFilePath, origImgFilePath, thumImgFilePath, thumWidth, thumHeight);
                        if (ro.isErr()) {
                            AppsLogger.err((AppContext)appAPI.getAppContext("com.actionsoft.apps.network"), (String)ro.getMsg());
                            break block35;
                        }
                        DCContext dcCtx = new DCContext(context.getSession(), context.getDCProfile(), context.getAppId(), context.getGroupValue(), context.getFileValue(), pdfFileName);
                        if (dcCtx.existFile()) {
                            context.getDCMessage().addAttr("pdfFilePath", (Object)dcCtx.getDownloadURL());
                        } else {
                            context.getDCMessage().addAttr("pdfFilePath", (Object)"");
                        }
                        dcCtx.setFileName(origImgFileName);
                        if (dcCtx.existFile()) {
                            context.getDCMessage().addAttr("origImgFilePath", (Object)dcCtx.getStremURL());
                        } else {
                            context.getDCMessage().addAttr("origImgFilePath", (Object)"");
                        }
                        dcCtx.setFileName(thumImgFileName);
                        if (dcCtx.existFile()) {
                            context.getDCMessage().addAttr("thumImgFilePath", (Object)dcCtx.getStremURL());
                            break block35;
                        }
                        context.getDCMessage().addAttr("thumImgFilePath", (Object)"");
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        context.setDCMessage("error", e.getMessage());
                    }
                }
            } else if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(postfix.substring(1, postfix.length()) + ",")) {
                ResponseObject ro = ResponseObject.newOkResponse();
                AppAPI appAPI = SDK.getAppAPI();
                AppContext networkApp = appAPI.getAppContext("com.actionsoft.apps.network");
                JodTool jodTool = new JodTool();
                if (jodTool.isActive()) {
                    try {
                        String pdfFileName = uuid + ".pdf";
                        String origImgFileName = uuid + ".jpg";
                        String thumImgFileName = uuid + "_thum.jpg";
                        String sid = context.getSession().getSessionId();
                        String srcFilePath = context.getPath() + context.getFileName();
                        String pdfFilePath = context.getPath() + pdfFileName;
                        String origImgFilePath = context.getPath() + origImgFileName;
                        String thumImgFilePath = context.getPath() + thumImgFileName;
                        int thumWidth = 130;
                        int thumHeight = 90;
                        ro = jodTool.file2PdfImage(sid, srcFilePath, pdfFilePath, origImgFilePath, thumImgFilePath, thumWidth, thumHeight);
                        if (ro.isOk()) {
                            DCContext dcCtx = new DCContext(context.getSession(), context.getDCProfile(), context.getAppId(), context.getGroupValue(), context.getFileValue(), pdfFileName);
                            if (dcCtx.existFile()) {
                                context.getDCMessage().addAttr("pdfFilePath", (Object)dcCtx.getDownloadURL());
                            } else {
                                context.getDCMessage().addAttr("pdfFilePath", (Object)"");
                            }
                            dcCtx.setFileName(origImgFileName);
                            if (dcCtx.existFile()) {
                                context.getDCMessage().addAttr("origImgFilePath", (Object)dcCtx.getStremURL());
                            } else {
                                context.getDCMessage().addAttr("origImgFilePath", (Object)"");
                            }
                            dcCtx.setFileName(thumImgFileName);
                            if (dcCtx.existFile()) {
                                context.getDCMessage().addAttr("thumImgFilePath", (Object)dcCtx.getStremURL());
                            } else {
                                context.getDCMessage().addAttr("thumImgFilePath", (Object)"");
                            }
                            File pdfFile = new File(pdfFilePath);
                            if (pdfFile.exists()) {
                                pdfFile.delete();
                            }
                            break block35;
                        }
                        AppsLogger.err((AppContext)networkApp, (String)ro.getMsg());
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        context.setDCMessage("error", e.getMessage());
                    }
                } else {
                    context.getDCMessage().addAttr("pdfFilePath", (Object)"");
                    context.getDCMessage().addAttr("origImgFilePath", (Object)"");
                    context.getDCMessage().addAttr("thumImgFilePath", (Object)"");
                }
            }
        }
        return true;
    }

    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        return DCStoreUtil.read((DCContext)context);
    }

    public void downloadComplete(Map<String, Object> param) {
        super.downloadComplete(param);
    }

    public void uploadSuccess(Map<String, Object> param) {
        try {
            DCContext dcContext = (DCContext)param.get("DCContext");
            dcContext.getDCMessage().addAttr("url", (Object)dcContext.getDownloadURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

