/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.util;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);

    public static HtmlPage getHtmlPage(String url) throws Exception {
        WebClient wc = new WebClient();
        wc.setCssEnabled(false);
        wc.setJavaScriptEnabled(false);
        wc.setTimeout(1000);
        HtmlPage page = (HtmlPage)wc.getPage(url);
        wc.closeAllWindows();
        return page;
    }

    public static String getSubString(String content, int len, String suffix) {
        if (StringUtils.isBlank((String)content)) {
            return "";
        }
        if (len > content.length()) {
            return content;
        }
        return content.substring(0, len) + suffix;
    }

    public static void main(String[] args) {
        try {
            HtmlPage page = HttpUtil.getHtmlPage("http://www.baidu.com");
            String title = page.getTitleText();
            String description = null;
            DomNodeList metas = page.getElementsByTagName("meta");
            for (HtmlElement meta : metas) {
                String name = meta.getAttribute("name");
                if (!name.toLowerCase().equals("description")) continue;
                description = meta.getAttribute("content");
                break;
            }
            if (description == null) {
                description = page.getBody().asText();
            }
            description = HttpUtil.getSubString(description, 300, "...");
            LOGGER.info("title:" + title);
            LOGGER.info("description: " + description);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }
}

