/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDao
extends DaoObject<NetworkModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkDao.class);

    public boolean clearNotework(String id) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append("APP_ACT_NETWORK").append(" where id=:id");
        params.put("id", id);
        return DBSql.update((String)sql.toString(), params) > 0;
    }

    public List<NetworkModel> loadNetworkOfCache() {
        List<NetworkModel> list = new ArrayList<NetworkModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM ").append("APP_ACT_NETWORK");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public List<NetworkModel> loadNetworkList(String userId, String searchValue, String order) throws SQLException {
        LinkedList<NetworkModel> list = new LinkedList();
        try {
            StringBuffer sql = new StringBuffer();
            if (UtilString.isEmpty((String)order)) {
                order = "createtime";
            }
            sql.append("select * from ").append("APP_ACT_NETWORK").append(" where createUserId = '").append(userId).append("' and networkName like '%").append(searchValue).append("%' order by ").append(order).append(" desc ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkModel getNoteworkById(String id) throws SQLException {
        NetworkModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append("APP_ACT_NETWORK").append(" where id = ? ");
            model = (NetworkModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public List<NetworkModel> findNetWorkByUserId(String userId) throws SQLException {
        LinkedList<NetworkModel> list = new LinkedList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT N.* FROM ").append("APP_ACT_NETWORK").append(" N LEFT JOIN APP_ACT_NETWORK_TEAM TE ON TE.NETWORKID = N.ID LEFT JOIN APP_ACT_NETWORK_TEAM_MEMBER TM ON TM.TEAMID = TE.ID AND TM.USERID = ? WHERE TM.USERID IS NOT NULL ORDER BY ORDER BY N.NETWORKNAME ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public String entityName() {
        return "APP_ACT_NETWORK";
    }

    public int insert(NetworkModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("NETWORKDESC", model.getNetworkDesc());
        paramsMap.put("NETWORKNAME", model.getNetworkName());
        paramsMap.put("NETWORKSTATUS", model.getNetworkStatus());
        paramsMap.put("CREATEUSERID", model.getCreateUserId());
        paramsMap.put("CREATEUSERNAME", model.getCreateUserName());
        paramsMap.put("CREATETIME", model.getCreateTime());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        paramsMap.put("ISANONYMITY", model.getIsAnonymity());
        int result = DBSql.update((String)DBSql.getInsertStatement((String)"APP_ACT_NETWORK", paramsMap), paramsMap);
        return result;
    }

    public RowMapper<NetworkModel> rowMapper() {
        return null;
    }

    public int update(NetworkModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("NETWORKNAME", model.getNetworkName());
        paramsMap.put("NETWORKSTATUS", model.getNetworkStatus());
        paramsMap.put("NETWORKDESC", model.getNetworkDesc());
        paramsMap.put("UPDATEUSERID", model.getUpdateUserId());
        paramsMap.put("UPDATEUSERNAME", model.getUpdateUserName());
        paramsMap.put("UPDATETIME", model.getUpdateTime());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        paramsMap.put("ISANONYMITY", model.getIsAnonymity());
        return super.update((Object)model.getId(), paramsMap);
    }

    private static class NetworkModelRowMapper
    implements RowMapper<NetworkModel> {
        private NetworkModelRowMapper() {
        }

        public NetworkModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkModel model = new NetworkModel();
            model.setId(rs.getString("ID"));
            model.setNetworkDesc(rs.getString("NETWORKDESC"));
            model.setNetworkLogo(rs.getString("NETWORKLOGO"));
            model.setNetworkName(rs.getString("NETWORKNAME"));
            model.setNetworkStatus(rs.getString("NETWORKSTATUS"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setUpdateUserId(rs.getString("UPDATEUSERID"));
            model.setUpdateUserName(rs.getString("UPDATEUSERNAME"));
            model.setUpdateTime(rs.getTimestamp("UPDATETIME"));
            model.setLastActive(rs.getTimestamp("LASTACTIVE"));
            model.setIsAnonymity(rs.getString("ISANONYMITY"));
            return model;
        }
    }
}

