/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTeams
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTeams.class);

    @Meta(parameter={"name: 'networkId', required: false, desc: '\u5de5\u4f5c\u7f51\u7edcID'", "name: 'join', required: false, desc: '\u662f\u5426\u52a0\u5165\u7684\u5c0f\u7ec4\uff0c\u9ed8\u8ba4\u4e3afalse\u3002true\uff1a\u8fd4\u56de\u52a0\u5165\u7684\u5c0f\u7ec4\uff0cfalse\uff1a\u8fd4\u56de\u6240\u6709\u5c0f\u7ec4'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String networkId = (String)params.get("networkId");
            boolean join = true;
            Object joinObj = params.get("join");
            if (joinObj != null) {
                join = Boolean.parseBoolean(joinObj.toString());
            }
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            List<Object> teamList = new ArrayList();
            if (!UtilString.isEmpty((String)networkId)) {
                teamList = this.loadTeamByNetwork(networkId, join, ctx.getUID());
            } else {
                List<NetworkModel> networkList = NetworkCache.loadNetwork(ctx.getUID());
                for (NetworkModel network : networkList) {
                    teamList.addAll(this.loadTeamByNetwork(network.getId(), join, ctx.getUID()));
                }
            }
            UtilListSort listSort = new UtilListSort();
            listSort.sort(teamList, "teamName", "asc");
            if (limit > 0) {
                Page<NetworkTeamModel> page = new Page<NetworkTeamModel>(start, limit, teamList);
                teamList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            JSONArray teams = NetworkDataUtil.team2JSON(teamList, ctx);
            ro.put("teams", (Object)teams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }

    private List<NetworkTeamModel> loadTeamByNetwork(String networkId, boolean join, String curUserId) {
        List<String> teamIds;
        ArrayList<NetworkTeamModel> tmpList;
        List<Object> teamList = new ArrayList();
        boolean isManager = NetworkDataUtil.isNetworkManager(networkId, curUserId);
        if (isManager) {
            teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
        } else {
            teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
            tmpList = new ArrayList<NetworkTeamModel>();
            teamIds = NetworkTeamMemberCache.getTeamIdListByUser(curUserId);
            for (NetworkTeamModel team : teamList) {
                if (!teamIds.contains(team.getId())) continue;
                if ("1".equals(team.getTeamStatus())) {
                    tmpList.add(team);
                    continue;
                }
                if (!"2".equals(team.getTeamStatus()) || !team.getCreateUserId().equals(curUserId)) continue;
                tmpList.add(team);
            }
            teamList = tmpList;
        }
        if (join && isManager) {
            tmpList = new ArrayList();
            teamIds = NetworkTeamMemberCache.getTeamIdListByUser(curUserId);
            for (NetworkTeamModel team : teamList) {
                if (!teamIds.contains(team.getId()) || !"1".equals(team.getTeamStatus())) continue;
                tmpList.add(team);
            }
            teamList = tmpList;
        }
        return teamList;
    }
}

