/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionUtil.class);

    private CollectionUtil() {
    }

    public static Collection getDiffent(Collection collmax, Collection collmin) {
        LinkedList<Object> csReturn = new LinkedList<Object>();
        Collection max = collmax;
        Collection min = collmin;
        if (collmax.size() < collmin.size()) {
            max = collmin;
            min = collmax;
        }
        HashMap map = new HashMap(max.size());
        for (Object e : max) {
            map.put(e, 1);
        }
        for (Object e : min) {
            if (map.get(e) == null) {
                csReturn.add(e);
                continue;
            }
            map.put(e, 2);
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            csReturn.add(entry.getKey());
        }
        return csReturn;
    }

    public static Collection getDiffentNoDuplicate(Collection collmax, Collection collmin) {
        return new HashSet(CollectionUtil.getDiffent(collmax, collmin));
    }

    public static void main(String[] args) {
        ArrayList<String> teamUserIds = new ArrayList<String>();
        teamUserIds.add("admin");
        String userIds = "user1,user2,user3,user4";
        String[] uids = userIds.split(",");
        List<String> addUids = Arrays.asList(uids);
        List result = (List)CollectionUtil.getDiffent(teamUserIds, addUids);
        if (result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                String uid = (String)result.get(i);
                if (addUids.contains(uid)) {
                    LOGGER.info("\u8bf4\u660e\u662f\u65b0\u589e\u52a0\u7684\u6210\u5458:" + uid);
                    continue;
                }
                if (!teamUserIds.contains(uid)) continue;
                LOGGER.info("\u8bf4\u660e\u662f\u539f\u6765\u6709\uff0c\u540e\u6765\u5220\u9664\u7684\u6210\u5458:" + uid);
            }
        }
    }
}

