/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTeamDao
extends DaoObject<NetworkTeamModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkTeamDao.class);

    public List<NetworkTeamModel> loadNetworkTeamOfCache() {
        List<NetworkTeamModel> list = new ArrayList<NetworkTeamModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_TEAM");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public List<NetworkTeamModel> findTeamsByNetwork(String networkId) throws SQLException {
        ArrayList<NetworkTeamModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_TEAM").append(" T WHERE T.TEAMSTATUS = '1' AND  T.NETWORKID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[]{networkId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public List<NetworkTeamModel> findTeamsByUserId(String userId) throws SQLException {
        ArrayList<NetworkTeamModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT T.* FROM ").append("APP_ACT_NETWORK_TEAM").append(" T LEFT JOIN APP_ACT_NETWORK_TEAM_MEMBER TM ON TM.TEAMID = T.ID WHERE T.TEAMSTATUS = '1' AND TM.USERID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[]{userId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public List<NetworkTeamModel> findTeamByAppId(String appId) throws SQLException {
        ArrayList<NetworkTeamModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT TE.* FROM ").append("APP_ACT_NETWORK_TEAM").append(" TE LEFT JOIN APP_ACT_NETWORK_APP_ACCESS AA ON AA.TEAMID = TE.ID AND TE.TEAMSTATUS = '1' AND AA.APPID = ? WHERE AA.ID IS NOT NULL ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[]{appId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkTeamModel getTeamBy(String id) throws SQLException {
        NetworkTeamModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_TEAM").append(" WHERE ID = ? ");
            model = (NetworkTeamModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public List<NetworkTeamMemberModel> findTeamMemberBy(String teamId) throws SQLException {
        ArrayList<NetworkTeamMemberModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_TEAM_MEMBER").append(" TM WHERE TM.TEAMID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamMemberModelRowMapper(), (Object[])new Object[]{teamId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public boolean isTeamManager(String teamId, String userId) throws SQLException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT COUNT(*) FROM ").append("APP_ACT_NETWORK_TEAM_MEMBER").append(" TM WHERE TM.TEAMID = ? AND TM.USERID = ? AND TM.MEMBERTYPE = ? ");
            int counts = DBSql.getInt((String)sql.toString(), (Object[])new Object[]{teamId, userId, "1"});
            return counts > 0;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public String stopTeamById(String teamId) {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append("APP_ACT_NETWORK_TEAM").append(" set teamStatus= '2' where id= ?");
        int result = DBSql.update((String)sql.toString(), (Object[])new Object[]{teamId});
        return result > 0 ? teamId : null;
    }

    public boolean clearNoteworkTeam(String id) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append("APP_ACT_NETWORK_TEAM").append(" where id=:id");
        params.put("id", id);
        return DBSql.update((String)sql.toString(), params) > 0;
    }

    public List<NetworkTeamModel> loadNetworkTeamList(String networkId, String searchValue, String order) throws SQLException {
        LinkedList<NetworkTeamModel> list = new LinkedList();
        try {
            StringBuffer sql = new StringBuffer();
            if (UtilString.isEmpty((String)order)) {
                order = "createtime";
            }
            sql.append("select * from ").append("APP_ACT_NETWORK_TEAM").append(" where teamstatus = '1' and  networkid = '").append(networkId).append("' and teamName like '%").append(searchValue).append("%' order by ").append(order).append(" desc ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkTeamModel getNoteworkTeamById(String id) throws SQLException {
        NetworkTeamModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append("APP_ACT_NETWORK_TEAM").append(" where id = ? ");
            model = (NetworkTeamModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkTeamModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public int insert(NetworkTeamModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("NETWORKID", model.getNetworkId());
        paramsMap.put("CREATETIME", model.getCreateTime());
        paramsMap.put("CREATEUSERID", model.getCreateUserId());
        paramsMap.put("CREATEUSERNAME", model.getCreateUserName());
        paramsMap.put("TEAMDESC", model.getTeamDesc());
        if (model.getTeamMemo() != null) {
            paramsMap.put("TEAMMEMO", model.getTeamMemo());
        }
        paramsMap.put("TEAMNAME", model.getTeamName());
        paramsMap.put("TEAMSTATUS", model.getTeamStatus());
        paramsMap.put("TEAMTYPE", model.getTeamType());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        int result = DBSql.update((String)DBSql.getInsertStatement((String)"APP_ACT_NETWORK_TEAM", paramsMap), paramsMap);
        return result;
    }

    public int update(NetworkTeamModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("NETWORKID", model.getNetworkId());
        paramsMap.put("TEAMNAME", model.getTeamName());
        paramsMap.put("TEAMTYPE", model.getTeamType());
        paramsMap.put("TEAMSTATUS", model.getTeamStatus());
        if (model.getTeamDesc() != null) {
            paramsMap.put("TEAMDESC", model.getTeamDesc());
        }
        if (model.getTeamMemo() != null) {
            paramsMap.put("TEAMMEMO", model.getTeamMemo());
        }
        paramsMap.put("UPDATEUSERID", model.getUpdateUserId());
        paramsMap.put("UPDATEUSERNAME", model.getUpdateUserName());
        paramsMap.put("UPDATETIME", model.getUpdateTime());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        return super.update((Object)model.getId(), paramsMap);
    }

    public String entityName() {
        return "APP_ACT_NETWORK_TEAM";
    }

    public RowMapper<NetworkTeamModel> rowMapper() {
        return new NetworkTeamModelRowMapper();
    }

    private static class NetworkTeamMemberModelRowMapper
    implements RowMapper<NetworkTeamMemberModel> {
        private NetworkTeamMemberModelRowMapper() {
        }

        public NetworkTeamMemberModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkTeamMemberModel model = new NetworkTeamMemberModel();
            model.setId(rs.getString("ID"));
            model.setTeamId(rs.getString("TEAMID"));
            model.setUserId(rs.getString("USERID"));
            model.setMemberType(rs.getString("MEMBERTYPE"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setLastActive(rs.getTimestamp("LASTACTIVE"));
            return model;
        }
    }

    private static class NetworkTeamModelRowMapper
    implements RowMapper<NetworkTeamModel> {
        private NetworkTeamModelRowMapper() {
        }

        public NetworkTeamModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkTeamModel model = new NetworkTeamModel();
            model.setId(rs.getString("ID"));
            model.setNetworkId(rs.getString("NETWORKID"));
            model.setTeamName(rs.getString("TEAMNAME"));
            model.setTeamLogo(rs.getString("TEAMLOGO"));
            model.setTeamDesc(rs.getString("TEAMDESC"));
            model.setTeamType(rs.getString("TEAMTYPE"));
            model.setTeamMemo(rs.getString("TEAMMEMO"));
            model.setTeamStatus(rs.getString("TEAMSTATUS"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setUpdateUserId(rs.getString("UPDATEUSERID"));
            model.setUpdateTime(rs.getTimestamp("UPDATETIME"));
            model.setLastActive(rs.getTimestamp("LASTACTIVE"));
            return model;
        }
    }
}

