/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkAppAccessCache;
import com.actionsoft.apps.network.cache.NetworkAppListCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.extend.TeamAppManager;
import com.actionsoft.apps.network.extend.TeamAppProfile;
import com.actionsoft.apps.network.model.NetworkAppAccessModel;
import com.actionsoft.apps.network.model.NetworkAppListModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTeamsByAppId
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTeamsByAppId.class);

    @Meta(parameter={"name: 'appId', required: true, desc: '\u5e94\u7528ID'", "name: 'title', required: true, desc: '\u6ce8\u518c\u6807\u9898'", "name: 'networkId', required: false, desc: '\u5de5\u4f5c\u7f51\u7edcID'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String appId = (String)params.get("appId");
            String title = (String)params.get("title");
            String networkId = params.get("networkId") == null ? "" : params.get("networkId").toString();
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            TeamAppProfile profile = TeamAppManager.getProfile(appId, title);
            String profileId = profile.getId();
            ArrayList<NetworkTeamModel> teamList = new ArrayList<NetworkTeamModel>();
            List<NetworkAppListModel> appList = NetworkAppListCache.loadAllNetworkByApp(profileId);
            for (NetworkAppListModel model : appList) {
                if (!UtilString.isEmpty((String)networkId)) {
                    if (!networkId.equals(model.getNetworkId())) continue;
                    teamList.addAll(this.getTeamByNetwork(model.getNetworkId(), profileId));
                    break;
                }
                teamList.addAll(this.getTeamByNetwork(model.getNetworkId(), profileId));
            }
            UtilListSort listSort = new UtilListSort();
            listSort.sort(teamList, "teamName", "asc");
            JSONArray teams = NetworkDataUtil.team2JSON(teamList, ctx);
            ro.put("teams", (Object)teams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }

    private List<NetworkTeamModel> getTeamByNetwork(String networkId, String profileId) {
        ArrayList<NetworkTeamModel> teamList = new ArrayList();
        List<NetworkAppAccessModel> accessList = NetworkAppAccessCache.loadAllNetworkAppAccessByApp(profileId, networkId);
        if (accessList.size() == 0) {
            teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
        } else {
            for (NetworkAppAccessModel appAccess : accessList) {
                NetworkTeamModel team = NetworkTeamCache.getModel(appAccess.getTeamId());
                if (!"1".equals(team.getTeamStatus())) continue;
                teamList.add(team);
            }
        }
        return teamList;
    }
}

