/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_sys;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ObjectEqualsOptimized {
    private static final List<DateTimeFormatter> FORMATTERS;

    public static boolean ObjectEquals(Object var1, Object var2) {
        if (var1 == null && var2 == null) {
            return true;
        }
        if (var1 == null && var2 != null && Objects.toString(var2, "").isEmpty() || var1 != null && Objects.toString(var1, "").isEmpty() && var2 == null) {
            return true;
        }
        if (var1 instanceof Date && var2 instanceof Date) {
            return ObjectEqualsOptimized.formatDate((Date)var1, "yyyy-MM-dd HH:mm:ss").equals(ObjectEqualsOptimized.formatDate((Date)var2, "yyyy-MM-dd HH:mm:ss"));
        }
        if (var1 instanceof Number && var2 instanceof Number) {
            return ObjectEqualsOptimized.compareNumbers((Number)var1, (Number)var2);
        }
        if (var1 != null && var2 != null) {
            LocalDateTime ldt1 = ObjectEqualsOptimized.tryParseLocalDateTime(var1);
            LocalDateTime ldt2 = ObjectEqualsOptimized.tryParseLocalDateTime(var2);
            if (ldt1 != null && ldt2 != null) {
                return ObjectEqualsOptimized.compareLocalDateTimes(ldt1, ldt2);
            }
            Date date1 = ObjectEqualsOptimized.parseDate(var1.toString());
            Date date2 = ObjectEqualsOptimized.parseDate(var2.toString());
            if (date1 != null && date2 != null) {
                if (date1.equals(date2)) {
                    return true;
                }
                if (date1.toInstant().equals(date2.toInstant())) {
                    return true;
                }
            }
        }
        return Objects.toString(var1, "").equals(Objects.toString(var2, ""));
    }

    private static boolean compareNumbers(Number num1, Number num2) {
        return Double.compare(num1.doubleValue(), num2.doubleValue()) == 0;
    }

    private static LocalDateTime tryParseLocalDateTime(Object obj) {
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (obj instanceof String) {
            return ObjectEqualsOptimized.parseLocalDateTime((String)obj);
        }
        return null;
    }

    private static boolean compareLocalDateTimes(LocalDateTime ldt1, LocalDateTime ldt2) {
        if (ldt1.equals(ldt2)) {
            return true;
        }
        if (ldt1.toLocalDate().equals(ldt2.toLocalDate()) && ldt1.toLocalTime().equals(ldt2.toLocalTime())) {
            return true;
        }
        return ldt1.toLocalDate().equals(ldt2.toLocalDate()) && ldt1.toLocalTime().equals(LocalTime.of(0, 0, 0)) && ldt2.toLocalTime().equals(LocalTime.of(0, 0, 0));
    }

    public static LocalDateTime parseLocalDateTime(String dateStr) {
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalDateTime.parse(dateStr, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static Date parseDate(String dateStr) {
        LocalDateTime localDateTime = ObjectEqualsOptimized.parseLocalDateTime(dateStr);
        if (localDateTime != null) {
            return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.format(date);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        formatters.add(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        formatters.add(DateTimeFormatter.ISO_LOCAL_DATE);
        formatters.add(DateTimeFormatter.ISO_LOCAL_TIME);
        formatters.add(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        formatters.add(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("dd-MMM-yyyy HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"));
        formatters.add(DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z uuuu"));
        FORMATTERS = Collections.unmodifiableList(formatters);
    }
}

