/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class contractCostController {
    private static final Logger logger;

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.costpick")
    public ResponseObject costPick(UserContext uc, String contractCostId, String warehouseProductId) throws SQLException {
        BO newBO = new BO();
        newBO.set("CONTRACT_COST_ID", (Object)contractCostId);
        newBO.set("WAREHOUSE_PRODUCT_ID", (Object)warehouseProductId);
        BO warhouseProductBO = SDK.getBOAPI().get("BO_EU_DNIVT_WAREHOUSE_PRODUCT", warehouseProductId);
        newBO.set("PRODUCT_ID", warhouseProductBO.get("PRODUCT_ID"));
        newBO.set("WAREHOUSE_ID", warhouseProductBO.get("WAREHOUSE_ID"));
        int warehouseProductQuantity = this.ObjToInt(warhouseProductBO.getString("QUANTITY"));
        logger.info("\u5e93\u5b58\u6570\u91cf:" + warehouseProductQuantity);
        int warehouseProductAvailableQuantity = this.ObjToInt(DBSql.getString((String)"SELECT SUM(AVAILABLE) FROM VIEW_EU_DNINVT_PRODUCT_INVENTORY where ID=?", (Object[])new Object[]{warehouseProductId}));
        logger.info("\u53ef\u7528\u5e93\u5b58\u6570\u91cf:" + warehouseProductAvailableQuantity);
        if (warehouseProductAvailableQuantity <= 0) {
            return ResponseObject.newErrResponse((String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
        if (warehouseProductQuantity <= 0) {
            return ResponseObject.newErrResponse((String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
        if (warehouseProductAvailableQuantity <= warehouseProductQuantity) {
            warehouseProductQuantity = warehouseProductAvailableQuantity;
        }
        int contractCostQuantity = this.ObjToInt(SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", contractCostId, "QUANTITY"));
        logger.info("\u5408\u540c\u4ea7\u54c1\u6570\u91cf:" + contractCostQuantity);
        int contractProductPickQuantity = this.ObjToInt(DBSql.getString((String)"SELECT SUM(QUANTITY) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=?  AND CLOSED=0", (Object[])new Object[]{contractCostId}));
        logger.info("\u5df2\u62e3\u8d27\u6570\u91cf:" + contractProductPickQuantity);
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_5670df3b3d164682a9aded38bae2e1be", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u62e3\u8d27\u5355");
        String binidid = processInstance.getId();
        newBO.setBindId(processInstance.getId());
        int quantity = contractCostQuantity - contractProductPickQuantity;
        if (quantity > warehouseProductQuantity) {
            newBO.set("PICK_QUANTITY", (Object)warehouseProductQuantity);
        } else {
            newBO.set("PICK_QUANTITY", (Object)quantity);
        }
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_PRODUCT_PICK", newBO, processInstance, uc);
        String url = SDK.getFormAPI().getFormURL("", uc.getSessionId(), binidid, "", 1, "", "", "");
        url = SDK.getPortalAPI().getPortalUrl() + "/r" + url.substring(1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    private int ObjToInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        String objStr = obj.toString();
        if (objStr.equals("")) {
            return 0;
        }
        if (objStr.contains(".")) {
            objStr = objStr.substring(0, objStr.indexOf("."));
        }
        return Integer.parseInt(objStr);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.costcanclepick")
    public ResponseObject costCanclePick(UserContext uc, String costProductId) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProductId);
        BO newBO = new BO();
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_a10ee583a11045d3b0f82f29b81ea1cd", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u53d6\u6d88\u62e3\u8d27\u5355");
        String binidid = processInstance.getId();
        newBO.setBindId(processInstance.getId());
        newBO.set("PICK_QUANTITY", bo.get("QUANTITY"));
        newBO.set("CONTRACT_COST_ID", bo.get("CONTRACT_COST_ID"));
        newBO.set("WAREHOUSE_ID", bo.get("WAREHOUSE_ID"));
        newBO.set("PRODUCT_ID", (Object)DBSql.getString((String)"SELECT PRODUCT_ID FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID=?", (Object[])new Object[]{bo.get("CONTRACT_COST_ID")}));
        newBO.set("COST_PRODUCT_ID", (Object)bo.getId());
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_PRODUCT_CANCLEPICK", newBO, processInstance, uc);
        String url = SDK.getFormAPI().getFormURL("", uc.getSessionId(), binidid, "", 1, "", "", "");
        url = SDK.getPortalAPI().getPortalUrl() + "/r" + url.substring(1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.TransferPro")
    public ResponseObject transferPro(UserContext uc, String costProductId) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProductId);
        BO newBO = new BO();
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_855e0ecd2a0e42dfaf45b3d1fff0c710", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u79fb\u5e93\u5355");
        String binidid = processInstance.getId();
        newBO.setBindId(processInstance.getId());
        newBO.set("QUANTITY", bo.get("QUANTITY"));
        newBO.set("CONTRACT_COST_ID", bo.get("CONTRACT_COST_ID"));
        newBO.set("WAREHOUSE_ID", bo.get("WAREHOUSE_ID"));
        newBO.set("PRODUCT_ID", (Object)DBSql.getString((String)"SELECT PRODUCT_ID FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID=?", (Object[])new Object[]{bo.get("CONTRACT_COST_ID")}));
        newBO.set("COST_PRODUCT_ID", (Object)bo.getId());
        SDK.getBOAPI().create("BO_EU_CTT_CONTRACT_PRODUCT_TRANSFER", newBO, processInstance, uc);
        String url = SDK.getFormAPI().getFormURL("", uc.getSessionId(), binidid, "", 1, "", "", "");
        url = SDK.getPortalAPI().getPortalUrl() + "/r" + url.substring(1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.getPickSNList")
    public ResponseObject getPickSNList(UserContext uc, String bindid, String warehouseProductId, Integer quantity) {
        RowMap stockMap = DBSql.getMap((String)"SELECT * FROM BO_EU_DNIVT_WAREHOUSE_PRODUCT WHERE ID=?", (Object[])new Object[]{warehouseProductId});
        List lotList = DBSql.getMaps((String)"SELECT b.* FROM bo_eu_dnivt_warehouse_product a JOIN BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT b ON a.BINDID=b.BINDID WHERE b.QUANTITY>0 AND a.ID=? ORDER BY b.IN_DATE", (Object[])new Object[]{warehouseProductId});
        List pickList = DBSql.getMaps((String)"SELECT a.* from BO_EU_DNCTT_CONTRACT_COST_PRODUCT a JOIN BO_EU_DNCTT_CONTRACT_COST b ON a.BINDID=b.BINDID WHERE a.WAREHOUSE_ID=? AND b.PRODUCT_ID=?", (Object[])new Object[]{stockMap.getString("WAREHOUSE_ID"), stockMap.getString("PRODUCT_ID")});
        ArrayList selectedSns = new ArrayList();
        for (RowMap lotMap : lotList) {
            String lotSNs = lotMap.getString("SN");
            ArrayList<String> lotsns = new ArrayList<String>();
            for (String SN : lotSNs.split(",")) {
                boolean isPicked = false;
                for (RowMap pickMap : pickList) {
                    String pickSNs = pickMap.getString("SN");
                    for (String pickSN : pickSNs.split(",")) {
                        if (!SN.equals(pickSN)) continue;
                        isPicked = true;
                        break;
                    }
                    if (!isPicked) continue;
                    break;
                }
                if (isPicked) continue;
                lotsns.add(SN);
            }
            if (lotsns.size() > quantity) {
                for (String sn : lotsns) {
                    BO bo = new BO();
                    bo.set("SN", (Object)sn);
                    bo.setBindId(bindid);
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_PRODUCT_PICKSN", bo, null);
                }
                continue;
            }
            quantity = quantity - lotsns.size();
            selectedSns.addAll(lotsns);
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)StringUtils.join(selectedSns, (String)","));
        return responseObject;
    }

    static {
        SDK.getLogAPI();
        logger = LogAPI.getLogger(contractCostController.class);
    }
}

