/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.helper.AttachementFile;
import com.actionsoft.apps.network.model.NetworkAppAccessModel;
import com.actionsoft.apps.network.model.NetworkAppListModel;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.Date;

@Controller
public class NetworkController {
    @Mapping(value="com.actionsoft.apps.network_home")
    public String networkHome(UserContext me, String streamId, String streamCommentId, String loc_teamId) throws SQLException {
        NetworkWeb web = new NetworkWeb(me);
        return web.getHome(streamId, streamCommentId, loc_teamId);
    }

    @Mapping(value="com.actionsoft.apps.network_search_networkdata")
    public String searchNetworkData(UserContext me, String networkId, String teamId, String searchValue, int start, int limit, String type) {
        NetworkWeb web = new NetworkWeb(me);
        return web.searchAllNetworkAndTeamData(networkId, teamId, searchValue, start, limit, type, false).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_load_networkandteamdata")
    public String loadNetworkAndTeamData(UserContext me, String sid) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkAndTeamData();
    }

    @Mapping(value="com.actionsoft.apps.network_load_userlist")
    public String getUserList(UserContext me, String term, String teamId, String limit) {
        NetworkWeb web = new NetworkWeb(me);
        int limitN = 10;
        if (!UtilString.isEmpty((String)limit)) {
            limitN = Integer.parseInt(limit);
        }
        return web.getUserList(term, teamId, limitN);
    }

    @Mapping(value="com.actionsoft.apps.network_team_loadAll_team_member")
    public String loadAllNetworkTeam(UserContext me, String teamId, String searchValue) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkTeamMember(teamId, searchValue);
    }

    @Mapping(value="com.actionsoft.apps.network_save_team_member")
    public String saveTeamMember(UserContext me, String teamId, String userId, String joinType, String memberType) {
        NetworkWeb web = new NetworkWeb(me);
        NetworkTeamMemberModel model = new NetworkTeamMemberModel();
        model.setId(UUIDGener.getUUID());
        model.setTeamId(teamId);
        if (userId.indexOf(",") > 0) {
            int index = userId.lastIndexOf(",");
            userId = userId.substring(index + 1, userId.length());
        }
        model.setUserId(userId);
        model.setJoinType(joinType);
        model.setMemberType(memberType);
        model.setMemberStatus("0");
        model.setCreateUserId(me.getUID());
        model.setCreateUserName(me.getUserName());
        return web.saveTeamMember(model).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_update_team_member")
    public String saveTeamMember(UserContext me, String memberId, String memberStatus, String deviceType) {
        NetworkWeb web = new NetworkWeb(me);
        return web.updateTeamMember(memberId, memberStatus, deviceType);
    }

    @Mapping(value="com.actionsoft.apps.network_save_team_member_data")
    public String saveTeamMemberData(UserContext me, String teamId, String userId, String joinType, String memberType) {
        NetworkWeb web = new NetworkWeb(me);
        NetworkTeamMemberModel model = new NetworkTeamMemberModel();
        model.setId(UUIDGener.getUUID());
        model.setTeamId(teamId);
        model.setUserId(userId);
        model.setJoinType(joinType);
        model.setMemberType(memberType);
        model.setMemberStatus("1");
        model.setCreateUserId(me.getUID());
        model.setCreateUserName(me.getUserName());
        return web.saveTeamMemberData(me, model).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_apply_team_member")
    public String applyTeamMember(UserContext me, String sid, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.applyNetworkTeamMember(teamId).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_delete_team_member")
    public String cleanTeamMember(UserContext me, String teamId, String userId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.cleanTeamMember(me, teamId, userId).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_team_loadAll_team")
    public String loadAllNetworkTeam(UserContext me, String networkId, String searchValue, String order, int start, int limit) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkTeam(networkId, searchValue, order, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_network_loadAll_network_name")
    public String loadAllNetwork(UserContext me) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetwork();
    }

    @Mapping(value="com.actionsoft.apps.network_team_loadAll_team_name")
    public String loadAllNetworkTeamBy(UserContext me, String networkId, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkTeamBy(networkId, appId);
    }

    @Mapping(value="com.actionsoft.apps.network_team_loadAll_team_app")
    public String loadAllNetworkTeamByApp(UserContext me, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkTeamBy(appId);
    }

    @Mapping(value="com.actionsoft.apps.network_team_delete_team_app")
    public String deleteNetworkTeamByApp(UserContext me, String id) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkTeamBy(id);
    }

    @Mapping(value="com.actionsoft.apps.network_save_team")
    public String saveNetworkTeam(UserContext me, String networkId, String teamId, String teamName, String teamLogo, String teamDesc, String teamType) {
        NetworkWeb web = new NetworkWeb(me);
        NetworkTeamModel model = new NetworkTeamModel();
        model.setNetworkId(networkId);
        model.setTeamDesc(teamDesc);
        model.setTeamName(teamName);
        model.setTeamType(teamType);
        model.setTeamLogo("");
        if (UtilString.isEmpty((String)teamId)) {
            model.setId(UUIDGener.getUUID());
            model.setTeamStatus("1");
            return web.saveNetworkTeam(model);
        }
        NetworkTeamModel teamModel = NetworkTeamCache.getModel(teamId);
        if (teamModel == null) {
            model.setId(teamId);
            model.setTeamStatus("1");
            return web.saveNetworkTeam(model);
        }
        teamModel.setTeamName(teamName);
        teamModel.setTeamDesc(teamDesc);
        teamModel.setTeamType(teamType);
        teamModel.setTeamLogo(teamLogo);
        return web.updateNetworkTeam(teamModel);
    }

    @Mapping(value="com.actionsoft.apps.network_save_team_toolbar")
    public String saveNetworkTeam(UserContext me, String teamId, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.saveNetworkAppToolBar(teamId, appId);
    }

    @Mapping(value="com.actionsoft.apps.network_update_team_toolbar")
    public String UpdateNetworkTeam(UserContext me, String teamId, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.updateNetworkAppToolBar(teamId, appId);
    }

    @Mapping(value="com.actionsoft.apps.network_load_team_toolbar")
    public String saveNetworkTeamByType(UserContext me, String teamId, String type) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkAppToolBar(teamId, type);
    }

    @Mapping(value="com.actionsoft.apps.network_delete_team_logo")
    public String deleteTeamLogo(UserContext me, String teamId, boolean force) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteTeamLogo(teamId, force);
    }

    @Mapping(value="com.actionsoft.apps.network_get_team_detail")
    public String getNetworkTeamDetail(UserContext me, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkTeamDetail(teamId);
    }

    @Mapping(value="com.actionsoft.apps.network_team_select_team")
    public String getNetworkTeamById(UserContext me, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkTeamById(teamId);
    }

    @Mapping(value="com.actionsoft.apps.network_update_team_memo")
    public String updateNetworkTeamMemo(UserContext ctx, String teamId, String teamMemo) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.updateNetworkTeamMemo(teamId, teamMemo);
    }

    @Mapping(value="com.actionsoft.apps.network_team_stop_team")
    public String stopNetworkTeam(UserContext me, String teamId, String teamStatus) {
        NetworkWeb web = new NetworkWeb(me);
        return web.stopNetworkTeam(teamId, teamStatus).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_team_delete_team")
    public String cleanNetworkTeam(UserContext me, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkTeam(me, teamId).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_team_loadAll_network")
    public String loadAllNetwork(UserContext me, String searchValue, String order, int start, int limit) {
        NetworkWeb web = new NetworkWeb(me);
        String sid = me.getSessionId();
        return web.loadAllNetwork(sid, searchValue, order, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_save_network")
    public String saveNetwork(UserContext me, String networkId, String networkName, String networkLogo, String networkDesc) {
        NetworkWeb web = new NetworkWeb(me);
        NetworkModel model = new NetworkModel();
        model.setNetworkDesc(networkDesc);
        model.setNetworkName(networkName);
        if (UtilString.isEmpty((String)networkId)) {
            model.setId(UUIDGener.getUUID());
            return web.saveNetwork(model);
        }
        NetworkModel networkModel = NetworkCache.getModel(networkId);
        if (networkModel == null) {
            model.setId(networkId);
            return web.saveNetwork(model);
        }
        networkModel.setNetworkName(networkName);
        networkModel.setNetworkDesc(networkDesc);
        return web.updateNetwork(networkModel);
    }

    @Mapping(value="com.actionsoft.apps.network_delete_network_logo")
    public String deleteNetworkLogo(UserContext me, String networkId, boolean force) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkLogo(networkId, force);
    }

    @Mapping(value="com.actionsoft.apps.network_network_save_applist")
    public String createNetworkAppList(UserContext me, String networkId, String appId, String appType) {
        NetworkWeb web = new NetworkWeb(me);
        NetworkAppListModel model = new NetworkAppListModel();
        model.setNetworkId(networkId);
        model.setAppId(appId);
        model.setAppType(appType);
        return web.saveNetworkAppLIst(model);
    }

    @Mapping(value="com.actionsoft.apps.network_network_loadall_applist")
    public String loadAllNetworkAppList(UserContext me, String networkId, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkAppList(networkId);
    }

    @Mapping(value="com.actionsoft.apps.network_network_stop_applist")
    public String stopNetworkAppList(UserContext me, String appId, String networkId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.stopNetworkAppList(appId, networkId);
    }

    @Mapping(value="com.actionsoft.apps.network_team_delete_network")
    public String cleanNetwork(UserContext me, String networkId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetwork(networkId);
    }

    @Mapping(value="com.actionsoft.apps.network_team_select_network")
    public String getNetworkById(UserContext me, String networkId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkById(networkId);
    }

    @Mapping(value="com.actionsoft.apps.network_get_networkmanager")
    public String getNetworkManager(UserContext me, RequestParams params, String sid, String networkId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkManagerUser(networkId);
    }

    @Mapping(value="com.actionsoft.apps.network_get_teammanagebyteamid")
    public String getTeamMemberByTeamId(UserContext me, RequestParams params, String sid, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkTeamMemberDetail(teamId);
    }

    @Mapping(value="com.actionsoft.apps.network_get_networkmanagerbyuid")
    public String getNetworkByUid(UserContext me, RequestParams params, String sid, String principal) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkManagerUser(principal);
    }

    @Mapping(value="com.actionsoft.apps.network_team_save_appaccess")
    public String createNetworkAppAccess(UserContext me, String teamId, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        NetworkAppAccessModel model = new NetworkAppAccessModel();
        model.setTeamId(teamId);
        model.setAppId(appId);
        return web.saveNetworkAppAccess(model);
    }

    @Mapping(value="com.actionsoft.apps.network_network_loadall_applist")
    public String loadAllNetworkAppAccess(UserContext me, String teamId, String appId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadAllNetworkAppAccess(teamId);
    }

    @Mapping(value="com.actionsoft.apps.network_team_seting_teammanage")
    public String setNetworkTeamManager(UserContext me, RequestParams params, String sid, String memberId, String memberType) {
        NetworkWeb web = new NetworkWeb(me);
        return web.setNetworkTeamManager(memberId, memberType);
    }

    @Mapping(value="com.actionsoft.apps.network_save_networkmanager")
    public String saveNetworkManager(UserContext me, RequestParams params, String sid, String networkId, String userId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.saveNetworkManager(me, networkId, userId);
    }

    @Mapping(value="com.actionsoft.apps.network_save_stream")
    public String saveNetworkStream(UserContext me, String networkId, String teamId, String streamType, String content, String attachement, String link, String tags, String notifier, String notifierTeam, String title, String praisePeople, String praiseBadge, String pariseDefinition, String voteContext, String sourceAppId, String sourceType, String sourceId, String channelType, String configContent, String srcObjectContent, String address, String isAnonymous) {
        NetworkWeb web = new NetworkWeb(me);
        return web.saveNetworkStream(networkId, teamId, streamType, content, attachement, link, tags, notifier, notifierTeam, title, praisePeople, praiseBadge, pariseDefinition, voteContext, sourceAppId, sourceType, sourceId, channelType, configContent, srcObjectContent, address, isAnonymous);
    }

    @Mapping(value="com.actionsoft.apps.network_get_stream_byid")
    public String saveNetworkStream(UserContext me, String streamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkStream(streamId);
    }

    @Mapping(value="com.actionsoft.apps.network_get_stream_sourcetype")
    public String getNetworkStreamSourceType(UserContext me) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getStreamSourceType().toString();
    }

    @Mapping(value="com.actionsoft.apps.network_load_stream")
    public String loadNetworkStream(UserContext me, String networkId, String teamId, int start, int limit) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkStream(networkId, teamId, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_load_stream_by_source")
    public String deleteNetworkStream(UserContext me, String sourceType, String sourceId, int start, int limit) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkStreamOfSource(sourceId, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_get_stream")
    public String getNetworkStream(UserContext me, String streamId, String streamCommentId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkStream(streamId, streamCommentId);
    }

    @Mapping(value="com.actionsoft.apps.network_load_my_stream")
    public String loadMyNetworkStream(UserContext me, String userId, String streamType, int start, int limit) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadMyNetworkStream(userId, streamType, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_get_stream_detail")
    public String getNetworkStreamDetail(UserContext me, String streamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkStreamDetail(streamId);
    }

    @Mapping(value="com.actionsoft.apps.network_save_streamcomment")
    public String saveNetworkStreamComment(UserContext me, String streamId, String commentId, String commentContent, String commentType, String teamId, String isAnonymous) {
        NetworkWeb web = new NetworkWeb(me);
        return web.saveNetworkStreamComment(streamId, commentId, commentContent, commentType, teamId, false, isAnonymous).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_save_streamcomment_source")
    public String saveNetworkStreamCommentSource(UserContext me, String streamId, String commentId, String commentContent, String commentType, String teamId, String sourceAppId, String sourceType, String sourceId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.saveNetworkStreamComment(streamId, commentId, commentContent, commentType, teamId, false, sourceAppId, sourceType, sourceId, "0").toString();
    }

    @Mapping(value="com.actionsoft.apps.network_delete_streamcomment")
    public String deleteNetworkStreamComment(UserContext me, String id) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkStreamComment(id);
    }

    @Mapping(value="com.actionsoft.apps.network_delete_streamcommentoperate")
    public String deleteNetworkStreamCommentOperate(UserContext me, String id) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkStreamCommentOperate(id);
    }

    @Mapping(value="com.actionsoft.apps.network_load_streamcommentlist")
    public String loadNetworkStreamComment(UserContext me, String streamId, String commentId, String commentType) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkStreamComment(streamId, commentId, commentType);
    }

    @Mapping(value="com.actionsoft.apps.network_load_streampraise")
    public String loadNetworkPraise(UserContext me, String streamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkPraise(streamId);
    }

    @Mapping(value="com.actionsoft.apps.network_delete_stream")
    public String deleteNetworkStream(UserContext me, String streamId, String configContent) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkStream(streamId, configContent);
    }

    @Mapping(value="com.actionsoft.apps.network_load_notices")
    public String loadNetworkStreamOfNotices(UserContext me, String networkId, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkStreamOfNotices(networkId, teamId);
    }

    @Mapping(value="com.actionsoft.apps.network_load_parises")
    public String loadNetworkStreamOfParises(UserContext me, String networkId, String teamId) {
        return new NetworkWeb().loadNetworkStreamOfParise(networkId, teamId);
    }

    @Mapping(value="com.actionsoft.apps.network.team_get_applist")
    public String getMetroNav(UserContext me, RequestParams params, String networkId, String type) {
        NetworkWeb web = new NetworkWeb(me);
        return web.geNetworktNav(networkId, type);
    }

    @Mapping(value="com.actionsoft.apps.network.team_get_appaccess")
    public String getTeamMetroNav(UserContext me, RequestParams params, String networkId, String teamId) {
        NetworkWeb web = new NetworkWeb(me);
        return web.geNetworktTeamNav(networkId, teamId).toString();
    }

    @Mapping(value="com.actionsoft.apps.network.team_open_appAccess")
    public String openTeamMetroNav(UserContext me, RequestParams params, String teamId, String id) {
        NetworkWeb web = new NetworkWeb(me);
        return web.openAppNav(teamId, id);
    }

    @Mapping(value="com.actionsoft.apps.network_load_join_team")
    public String loadJoinTeams(UserContext ctx, String networkId) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.loadJoinTeams(networkId);
    }

    @Mapping(value="com.actionsoft.apps.network_find_network_topic")
    public String findNetworkTopic(UserContext ctx, String value, int limit, String networkId, String teamId) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.findNetworkTopic(value, limit, networkId, teamId).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_load_network_topic")
    public String loadNetworkTopic(UserContext ctx, String networkId, String teamId, int start, int limit) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.loadNetworkTopic(networkId, teamId, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_load_my_network_topic")
    public String loadNetworkTopicOfMine(UserContext ctx, int start, int limit) {
        NetworkWeb web = new NetworkWeb();
        return web.loadNetworkTopicOfMine(start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_get_topic_byname")
    public String getNetworkTopicByName(UserContext ctx, String topicName) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.getNetworkTopicByName(topicName);
    }

    @Mapping(value="com.actionsoft.apps.network_load_topic_stream")
    public String loadNetworkStreamOfTopic(UserContext me, String topicId, int start, int limit) {
        NetworkWeb web = new NetworkWeb(me);
        return web.loadNetworkStreamOfTopic(topicId, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_search_at_someone")
    public String searchAtSomeone(UserContext ctx, String value, int limit, String networkId) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.searchAtSomeone(networkId, value, limit).toString();
    }

    @Mapping(value="com.actionsoft.apps.network_load_atme_stream")
    public String loadAtMe(UserContext ctx, int start, int limit, boolean unRead) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.loadAtMe(start, limit, unRead);
    }

    @Mapping(value="com.actionsoft.apps.network_load_unread_stream_message_list")
    public String loadNetworkUnReadMessageList(UserContext ctx) throws Exception {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.queryStreamUnreadMessage();
    }

    @Mapping(value="com.actionsoft.apps.network_file_save")
    public String getNetworkFileSave(UserContext me, String uid, int x, int y, int w, int h, String fileName, String groupValue) {
        NetworkWeb web = new NetworkWeb(me);
        return web.getNetworkFileSave(me, uid, x, y, w, h, fileName, groupValue);
    }

    @Mapping(value="com.actionsoft.apps.network_stream_deletefile")
    public String deleteNetworkStreamAttachment(UserContext ctx, RequestParams params, String attachements) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            if (attachements != null && !UtilString.isEmpty((String)attachements)) {
                JSONArray files = JSONArray.parseArray((String)attachements);
                int len = files.size();
                String groupValue = UtilDate.yearFormat((Date)new Date()) + UtilDate.monthFormat((Date)new Date());
                for (int i = 0; i < len; ++i) {
                    AttachementFile file = (AttachementFile)JSONObject.toJavaObject((JSON)files.getJSONObject(i), AttachementFile.class);
                    DCContext dc = new DCContext(ctx, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, ctx.getUID(), file.getFileName());
                    dc.delete();
                    if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(file.getFileType() + ",")) {
                        dc.setFileName(file.getFileUUID() + "_thum.jpg");
                        dc.delete();
                        continue;
                    }
                    if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(file.getFileType() + ",")) {
                        dc.setFileName(file.getFileUUID() + ".pdf");
                        dc.delete();
                        dc.setFileName(file.getFileUUID() + ".jpg");
                        dc.delete();
                        dc.setFileName(file.getFileUUID() + "_thum.jpg");
                        dc.delete();
                        continue;
                    }
                    if (!"pdf".equals(file.getFileType())) continue;
                    dc.setFileName(file.getFileUUID() + ".jpg");
                    dc.delete();
                    dc.setFileName(file.getFileUUID() + "_thum.jpg");
                    dc.delete();
                }
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
        }
        return result.toString();
    }

    @Mapping(value="com.actionsoft.apps.network_load_team_by_stream")
    public String loadTeamByStrem(UserContext ctx, String streamId) {
        NetworkWeb web = new NetworkWeb();
        return web.loadTeamByStream(streamId);
    }

    @Mapping(value="com.actionsoft.apps.network_resolve_stream_url")
    public String resolveAtURL(UserContext ctx, String url) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.resolveAtURL(url);
    }

    @Mapping(value="com.actionsoft.apps.network_storage_mydriver")
    public String storageMyDriver(UserContext ctx, String groupValue, String fileValue, String fileName, String fileActName, int fileSize) {
        NetworkWeb web = new NetworkWeb();
        return web.storageMyDriver(groupValue, fileValue, fileName, fileActName, fileSize);
    }

    @Mapping(value="com.actionsoft.apps.network_stream_of_channeltype")
    public String loadNetworkStreamOfChannelType(UserContext ctx, String sourceType, String sourceDeptId, String channelType, String searchVal, boolean isBoss, int start, int limit) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.loadNetworkStreamOfChannelType(sourceType, sourceDeptId, channelType, searchVal, isBoss, start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_openfile")
    public String openFile(UserContext me, String repositoryName, String groupValue, String fileValue, String fileName, String fileNameOriginal, String isShowDefaultToolbar, String isCopy, String isPrint, String isDownload) {
        NetworkWeb web = new NetworkWeb();
        return web.openFile(me, repositoryName, groupValue, fileValue, fileName, fileNameOriginal, isShowDefaultToolbar, isCopy, isPrint, isDownload);
    }

    @Mapping(value="com.actionsoft.apps.network_get_userlist")
    public String getUserList(UserContext me, String userIds) {
        NetworkWeb web = new NetworkWeb();
        return web.getUserAddressList(me, userIds);
    }

    @Mapping(value="com.actionsoft.apps.network_load_myfavorite_stream")
    public String loadAtMe(UserContext ctx, int start, int limit) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.loadMyFavorite(start, limit);
    }

    @Mapping(value="com.actionsoft.apps.network_delete_streamcomment_favorite")
    public String deleteNetworkStreamCommentFavorite(UserContext me, String id) {
        NetworkWeb web = new NetworkWeb(me);
        return web.deleteNetworkStreamCommentFavorite(id);
    }

    @Mapping(value="com.actionsoft.apps.network_isanonymous")
    public String updateNetworkAnonymity(UserContext ctx, String networkId, String isAnonymous) {
        NetworkWeb web = new NetworkWeb(ctx);
        return web.updateNetworkAnonymity(ctx, networkId, isAnonymous);
    }
}

