/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.UtilListSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Controller
public class NetworkUDFController {
    @Mapping(value="com.actionsoft.apps.network_load_stream_by_sourceAndType")
    public String getNetworkStreamBySourceType(UserContext me, String sourceTypes, String sourceId, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<Object> streamList = new ArrayList();
            streamList = NetworkStreamCache.getStreamOfSourceId(sourceId);
            if (StringUtils.isNotBlank((CharSequence)sourceTypes)) {
                List<String> stArr = Arrays.asList(sourceTypes.split(","));
                streamList = streamList.stream().filter(item -> stArr.contains(item.getSourceType())).collect(Collectors.toList());
            }
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "DESC");
            Page page = new Page(start, limit, streamList);
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), me));
            result.put("page", page);
        }
        catch (Exception e) {
            result.err();
            result.msg(e.getMessage());
        }
        return result.toString();
    }
}

