/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import java.net.URLDecoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateStreamComment
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateStreamComment.class);

    @Meta(parameter={"name: 'streamId', required: true, desc: '\u52a8\u6001\u4fe1\u606fID'", "name: 'teamId', required: false, desc: '\u5c0f\u7ec4ID'", "name: 'commentId', required: false, desc: '\u8bc4\u8bba\u4fe1\u606fID'", "name: 'commentContent', required: true, desc: '\u8bc4\u8bba\u5185\u5bb9'", "name: 'commentType', required: true, desc: '\u8bc4\u8bba\u7c7b\u578b'", "name: 'sourceAppId', required: false, desc:'\u4fe1\u606f\u6d41\u6765\u81ea\uff0c\u5982com.actionsoft.apps.coe.pal'", "name: 'sourceType', required: false, desc:'\u4fe1\u606f\u6d41\u6765\u6e90\uff0c\u5982CoE.PAL.Designer\u3001CoE.BPA'", "name: 'sourceId', required: false, desc:'\u6765\u6e90ID\uff0c\u5982\u6d41\u7a0b\u56feId'", "name: 'ipAddress', required: false, desc:'IP\u5730\u5740'", "name: 'deviceType', required: false, desc:'\u8bbe\u5907\u540d\u79f0'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        String sid = params.get("sid").toString();
        UserContext ctx = UserContext.fromSessionId((String)sid);
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            String streamId = (String)params.get("streamId");
            String teamId = (String)params.get("teamId");
            String commentId = (String)params.get("commentId");
            String commentContent = (String)params.get("commentContent");
            commentContent = URLDecoder.decode(commentContent, "UTF-8");
            String commentType = params.get("commentType").toString();
            String sourceAppId = params.get("sourceAppId") == null ? "" : params.get("sourceAppId").toString();
            String sourceType = params.get("sourceType") == null ? "" : params.get("sourceType").toString();
            String sourceId = params.get("sourceId") == null ? "" : params.get("sourceId").toString();
            String ipAddress = params.get("ipAddress") == null ? ctx.getClientIP() : params.get("ipAddress").toString();
            String deviceType = params.get("deviceType") == null ? ctx.getDeviceType() : params.get("deviceType").toString();
            NetworkWeb web = new NetworkWeb(ctx);
            if (commentType.equals("1")) {
                commentContent = "\u70b9\u8d5e";
            } else if (commentType.equals("2")) {
                commentContent = "\u6536\u85cf";
            }
            result = web.saveNetworkStreamComment(streamId, commentId, commentContent, commentType, teamId, sourceAppId, sourceType, sourceId, ipAddress, deviceType, true, "0");
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result;
    }
}

