/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.cache.NetworkStreamCommentCache;
import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStreamComment
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteStreamComment.class);

    @Meta(parameter={"name: 'commentId', required: true, desc: '\u8bc4\u8bba\u4fe1\u606fID'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        String sid = params.get("sid").toString();
        UserContext ctx = UserContext.fromSessionId((String)sid);
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String commentId = (String)params.get("commentId");
            NetworkStreamCommentModel comment = NetworkStreamCommentCache.getModel(commentId);
            if (comment == null) {
                ro.err("\u4fe1\u606f\u672a\u627e\u5230");
                return ro;
            }
            NetworkStreamModel stream = NetworkStreamCache.getModel(comment.getStreamId());
            boolean isTeamManager = NetworkDataUtil.isTeamManager(stream.getId(), ctx.getUID());
            if (!isTeamManager && !ctx.getUID().equals(comment.getCreateUserId())) {
                ro.err("\u65e0\u64cd\u4f5c\u6743\u9650");
                return ro;
            }
            NetworkStreamCommentCache.removeById(commentId);
            ro.put("streamOld", (Object)NetworkDataUtil.stream2JSONOfOriginal(stream, ctx));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }
}

