/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStreamBySourceId
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStreamBySourceId.class);

    @Meta(parameter={"name: 'sourceId', required: true, desc: '\u6765\u6e90ID'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String sourceId = (String)params.get("sourceId");
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            List<Object> streamList = new ArrayList();
            streamList = NetworkStreamCache.getStreamOfSourceId(sourceId);
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "DESC");
            Page page = new Page(start, limit, streamList);
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), ctx));
            ro.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

