/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.model.NetworkTeamMemberDto;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.ORGAPI;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTeamMemberByTeamId
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTeamMemberByTeamId.class);

    @Meta(parameter={"name: 'teamId', required: true, desc: '\u5c0f\u7ec4ID'", "name: 'key', required: false, desc: '\u641c\u7d22\u5173\u952e\u5b57'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String teamId = (String)params.get("teamId");
            String sid = (String)params.get("sid");
            String key = params.get("key") == null ? "" : params.get("key").toString();
            UserContext context = UserContext.fromSessionId((String)sid);
            List<NetworkTeamMemberDto> list = NetworkTeamMemberCache.loadNetworkTeamMemberDtoByTeam(teamId, "1", context);
            if (!UtilString.isEmpty((String)key)) {
                key = key.toLowerCase();
                ArrayList<NetworkTeamMemberDto> temp = new ArrayList<NetworkTeamMemberDto>();
                ORGAPI orgApi = SDK.getORGAPI();
                for (NetworkTeamMemberDto model : list) {
                    UserModel user = orgApi.getUser(model.getUserId());
                    if (user == null || user.isClosed() || !user.getUserName().toLowerCase().contains(key)) continue;
                    temp.add(model);
                }
                list = temp;
            }
            UtilListSort sortUtil = new UtilListSort();
            sortUtil.sort(list, "lastActive", "DESC");
            sortUtil.sort(list, "memberType", "asc");
            JSONArray members = NetworkDataUtil.teamMemberDto2JSON(list, context);
            ro.put("teamMembers", (Object)members);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

