/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUserStreams
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryUserStreams.class);

    @Meta(parameter={"name: 'userId', required: true, desc: '\u7528\u6237\u8d26\u53f7'", "name: 'streamType', required: false, desc: '\u4fe1\u606f\u6d41\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4e3a\u52a8\u6001'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String userId = (String)params.get("userId");
            String streamType = params.get("streamType") == null ? "1" : params.get("streamType").toString();
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            JSONObject userResult = JSONObject.parseObject((String)SDK.getPortalAPI().getUserInfo(ctx, userId)).getJSONObject("data");
            String positionName = userResult.getString("positionName");
            String departmentName = userResult.getString("departmentName");
            NetworkWeb web = new NetworkWeb(ctx);
            List<NetworkStreamModel> streamList = web.loadMyNetworkStream(userId, streamType);
            if (limit > 0) {
                Page<NetworkStreamModel> page = new Page<NetworkStreamModel>(start, limit, streamList);
                streamList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            ro.put("positionName", (Object)positionName);
            ro.put("departmentName", (Object)departmentName);
            ro.put("streams", (Object)NetworkDataUtil.stream2JSONOfOriginal(streamList, ctx));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

