/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.dao.NetworkDao;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.sdk.local.SDK;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class NetworkCache
extends Cache<String, NetworkModel> {
    public static final Comparator<NetworkModel> SORT_CREATETIME = new Comparator<NetworkModel>(){

        @Override
        public int compare(NetworkModel o1, NetworkModel o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };

    public NetworkCache(CachePluginProfile profile) {
        super(profile);
    }

    public static void putModel(NetworkModel model) {
        NetworkModel old = NetworkCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkDao().insert(model) : new NetworkDao().update(model);
        if (result == 1) {
            NetworkCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkModel getModel(String id) {
        return (NetworkModel)((Object)NetworkCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkDao().delete(id);
        if (result == 1) {
            NetworkCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static List<NetworkModel> loadAllNetwork() {
        Iterator iter = NetworkCache.getCache().iteratorSorted(SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static String loadFirstNetworkId() {
        NetworkModel model = new NetworkModel();
        String networkId = null;
        UtilListSort sortList = new UtilListSort();
        List<NetworkModel> allNetwork = NetworkCache.loadAllNetwork();
        sortList.sort(allNetwork, "createTime", "asc");
        int len = allNetwork.size();
        if (len > 0 && (model = allNetwork.get(0)) != null) {
            networkId = model.getId();
        }
        return networkId;
    }

    public static List<NetworkModel> loadNetwork(String userId, String networkName) {
        ArrayList<NetworkModel> list = new ArrayList<NetworkModel>();
        List<NetworkModel> allNetwork = NetworkCache.loadAllNetwork();
        boolean isAdmin = SDK.getPermAPI().isSystemAdministrator(userId);
        if (allNetwork.size() > 0) {
            for (NetworkModel model : allNetwork) {
                boolean isManager = NetworkDataUtil.isNetworkManager(model.getId(), userId);
                boolean flag = SDK.getPermAPI().havingACPermission(userId, "network.myAcTypeManage", model.getId(), 0);
                if (!flag && !isAdmin && !isManager && !model.getCreateUserId().equals(userId) || model.getNetworkName().toLowerCase().indexOf(networkName.toLowerCase()) <= -1) continue;
                list.add(model);
            }
        }
        return list;
    }

    public static List<NetworkModel> loadNetworkBy(String userId, String networkName) {
        ArrayList<NetworkModel> list = new ArrayList<NetworkModel>();
        List<NetworkModel> allNetwork = NetworkCache.loadAllNetwork();
        boolean isAdmin = SDK.getPermAPI().isSystemAdministrator(userId);
        if (allNetwork.size() > 0) {
            for (NetworkModel model : allNetwork) {
                boolean isManager = NetworkDataUtil.isNetworkManager(model.getId(), userId);
                boolean flag = SDK.getPermAPI().havingACPermission(userId, "network.myAcTypeManage", model.getId(), 0);
                List acList = SDK.getPermAPI().getACListByResource("network.myAcTypeManage", model.getId(), 0);
                if (!flag && acList.size() >= 1 && !isAdmin && !isManager && !model.getCreateUserId().equals(userId) || model.getNetworkName().toLowerCase().indexOf(networkName.toLowerCase()) <= -1) continue;
                list.add(model);
            }
        }
        return list;
    }

    public static List<String> loadNetworkByUserId(String userId, String networkName) {
        ArrayList<String> list = new ArrayList<String>();
        List<NetworkModel> allNetwork = NetworkCache.loadAllNetwork();
        boolean isAdmin = SDK.getPermAPI().isSystemAdministrator(userId);
        if (allNetwork.size() > 0) {
            for (NetworkModel model : allNetwork) {
                boolean isManager = NetworkDataUtil.isNetworkManager(model.getId(), userId);
                boolean flag = SDK.getPermAPI().havingACPermission(userId, "network.myAcTypeManage", model.getId(), 0);
                if (!flag && !isAdmin && !isManager && !model.getCreateUserId().equals(userId) || model.getNetworkName().toLowerCase().indexOf(networkName.toLowerCase()) <= -1 || list.contains(model.getId())) continue;
                list.add(model.getId());
            }
        }
        return list;
    }

    public static List<String> loadNetworkByUserId(String userId) {
        return NetworkCache.loadNetworkByUserId(userId, "");
    }

    public static List<NetworkModel> loadNetwork(String userId) {
        return NetworkCache.loadNetwork(userId, "");
    }

    public static List<NetworkModel> loadNetworkBy(String userId) {
        return NetworkCache.loadNetworkBy(userId, "");
    }

    public void load() {
        List<NetworkModel> list = new NetworkDao().loadNetworkOfCache();
        for (NetworkModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u5de5\u4f5c\u7f51\u7edc [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkCache getCache() {
        return (NetworkCache)CacheManager.getCache(NetworkCache.class);
    }
}

