/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.cache.NetworkStream_AtUserIndex;
import com.actionsoft.apps.network.cache.NetworkStream_CreateUserIndex;
import com.actionsoft.apps.network.cache.NetworkStream_NetworkIndex;
import com.actionsoft.apps.network.cache.NetworkStream_NotifierUserIndex;
import com.actionsoft.apps.network.cache.NetworkStream_ParentSourceIndex;
import com.actionsoft.apps.network.cache.NetworkStream_PraiseUserIndex;
import com.actionsoft.apps.network.cache.NetworkStream_SourceDeptIndex;
import com.actionsoft.apps.network.cache.NetworkStream_SourceIndex;
import com.actionsoft.apps.network.cache.NetworkStream_SourceTypeIndex;
import com.actionsoft.apps.network.cache.NetworkStream_TeamIndex;
import com.actionsoft.apps.network.cache.NetworkStream_TopicIndex;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.dao.NetworkStreamDao;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class NetworkStreamCache
extends Cache<String, NetworkStreamModel> {
    public static final Comparator<NetworkStreamModel> SORT_CREATETIME = new Comparator<NetworkStreamModel>(){

        @Override
        public int compare(NetworkStreamModel o1, NetworkStreamModel o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };
    public static final Comparator<NetworkStreamModel> SORT_SOURCETYPE = new Comparator<NetworkStreamModel>(){

        @Override
        public int compare(NetworkStreamModel o1, NetworkStreamModel o2) {
            return o1.getSourceType().compareTo(o2.getSourceType());
        }
    };

    public NetworkStreamCache(CachePluginProfile profile) {
        super(profile);
        this.registeIndex(NetworkStream_NetworkIndex.class, (CacheIndex)new NetworkStream_NetworkIndex());
        this.registeIndex(NetworkStream_TeamIndex.class, (CacheIndex)new NetworkStream_TeamIndex());
        this.registeIndex(NetworkStream_TopicIndex.class, (CacheIndex)new NetworkStream_TopicIndex());
        this.registeIndex(NetworkStream_AtUserIndex.class, (CacheIndex)new NetworkStream_AtUserIndex());
        this.registeIndex(NetworkStream_CreateUserIndex.class, (CacheIndex)new NetworkStream_CreateUserIndex());
        this.registeIndex(NetworkStream_PraiseUserIndex.class, (CacheIndex)new NetworkStream_PraiseUserIndex());
        this.registeIndex(NetworkStream_ParentSourceIndex.class, (CacheIndex)new NetworkStream_ParentSourceIndex());
        this.registeIndex(NetworkStream_SourceDeptIndex.class, (CacheIndex)new NetworkStream_SourceDeptIndex());
        this.registeIndex(NetworkStream_SourceIndex.class, (CacheIndex)new NetworkStream_SourceIndex());
        this.registeIndex(NetworkStream_SourceTypeIndex.class, (CacheIndex)new NetworkStream_SourceTypeIndex());
        this.registeIndex(NetworkStream_NotifierUserIndex.class, (CacheIndex)new NetworkStream_NotifierUserIndex());
    }

    public static void putModel(NetworkStreamModel model) {
        NetworkStreamModel old = NetworkStreamCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkStreamDao().insert(model) : new NetworkStreamDao().update(model);
        if (result == 1) {
            NetworkStreamCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkStreamModel getModel(String id) {
        return (NetworkStreamModel)((Object)NetworkStreamCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkStreamDao().delete(id);
        if (result == 1) {
            NetworkStreamCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static Iterator<NetworkStreamModel> getStreamOfNetwork(String networkId) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_NetworkIndex.class, (Serializable)((Object)networkId), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfNetwork(String networkId) {
        return Cache.iteratorToList(NetworkStreamCache.getStreamOfNetwork(networkId));
    }

    public static List<NetworkStreamModel> loadStreamOfNetwork() {
        Iterator iter = NetworkStreamCache.getCache().iteratorSorted(SORT_CREATETIME);
        List list = Cache.iteratorToList((Iterator)iter);
        return list;
    }

    public static List<NetworkStreamModel> loadStreamOfNetwork(String networkId, String userId) {
        Iterator<NetworkStreamModel> iter = NetworkStreamCache.getStreamOfNetwork(networkId);
        List<String> teamList = NetworkTeamMemberCache.getTeamIdListByUser(userId);
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        while (iter.hasNext()) {
            NetworkTeamModel teamModel;
            NetworkStreamModel model = iter.next();
            String teamId = model.getTeamId();
            if (UtilString.isEmpty((String)teamId)) {
                list.add(model);
            }
            if (!teamList.contains(teamId) || (teamModel = NetworkTeamCache.getModel(teamId)) == null || !teamModel.getTeamStatus().equals("1")) continue;
            list.add(model);
        }
        return list;
    }

    public static List<NetworkStreamModel> loadCreateStreamOfNetwork(String networkId, String userId) {
        Iterator<NetworkStreamModel> iter = NetworkStreamCache.getStreamOfNetwork(networkId);
        List<String> teamList = NetworkTeamMemberCache.getTeamIdListByUser(userId);
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        while (iter.hasNext()) {
            NetworkStreamModel model = iter.next();
            if (!model.getCreateUserId().equals(userId) || !UtilString.isEmpty((String)model.getTeamId()) && !teamList.contains(model.getTeamId())) continue;
            list.add(model);
        }
        return list;
    }

    public static List<NetworkStreamModel> loadNoticeStreamOfNetwork(String networkId, String userId) {
        Iterator<NetworkStreamModel> iter = NetworkStreamCache.getStreamOfNetwork(networkId);
        List<String> teamList = NetworkTeamMemberCache.getTeamIdListByUser(userId);
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        while (iter.hasNext()) {
            NetworkStreamModel model = iter.next();
            if (!UtilString.isEmpty((String)model.getTeamId()) && !teamList.contains(model.getTeamId()) || !"3".equals(model.getStreamType())) continue;
            list.add(model);
        }
        return list;
    }

    public static List<NetworkStreamModel> loadPraiseStreamOfNetwork(String networkId, String userId) {
        Iterator<NetworkStreamModel> iter = NetworkStreamCache.getStreamOfNetwork(networkId);
        List<String> teamList = NetworkTeamMemberCache.getTeamIdListByUser(userId);
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        while (iter.hasNext()) {
            NetworkStreamModel model = iter.next();
            if (!UtilString.isEmpty((String)model.getTeamId()) && !teamList.contains(model.getTeamId()) || !"4".equals(model.getStreamType())) continue;
            list.add(model);
        }
        return list;
    }

    public static Iterator<NetworkStreamModel> getStreamOfTeam(String teamId) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_TeamIndex.class, (Serializable)((Object)teamId), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfTeam(String teamId) {
        List list = Cache.iteratorToList(NetworkStreamCache.getStreamOfTeam(teamId));
        return list;
    }

    public static List<NetworkStreamModel> loadNoticeStreamOfTeam(String teamId) {
        Iterator<NetworkStreamModel> iter = NetworkStreamCache.getStreamOfTeam(teamId);
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        while (iter.hasNext()) {
            NetworkStreamModel model = iter.next();
            if (!"3".equals(model.getStreamType())) continue;
            list.add(model);
        }
        return list;
    }

    public static List<NetworkStreamModel> loadPraiseStreamOfTeam(String teamId) {
        Iterator<NetworkStreamModel> iter = NetworkStreamCache.getStreamOfTeam(teamId);
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        while (iter.hasNext()) {
            NetworkStreamModel model = iter.next();
            if (!"4".equals(model.getStreamType()) || !teamId.equals(model.getTeamId())) continue;
            list.add(model);
        }
        return list;
    }

    public static List<NetworkStreamModel> loadStreamOfSourceType(String sourceType, String sourceDeptId, String userId) {
        List<NetworkStreamModel> lists;
        List<String> sourceDeptIdList = new ArrayList<String>();
        ArrayList<NetworkStreamModel> streamList = new ArrayList<NetworkStreamModel>();
        List<Object> sourceTypeList = new ArrayList<String>();
        if (!UtilString.isEmpty((String)sourceType)) {
            if (sourceType.indexOf(",") > -1) {
                String[] sourceTypes = sourceType.split(",");
                if (sourceTypes.length > 0) {
                    sourceTypeList = Arrays.asList(sourceTypes);
                }
            } else {
                sourceTypeList.add(sourceType);
            }
            if (sourceTypeList.size() > 0) {
                for (String string : sourceTypeList) {
                    lists = NetworkStreamCache.getStreamOfSourceType(string);
                    if (lists.size() <= 0) continue;
                    for (NetworkStreamModel model : lists) {
                        if (model == null || !model.getCreateUserId().equals(userId)) continue;
                        streamList.add(model);
                    }
                }
            }
        }
        if (!UtilString.isEmpty((String)sourceDeptId)) {
            if (sourceDeptId.indexOf(",") > -1) {
                String[] sourceDeptIds = sourceDeptId.split(",");
                if (sourceDeptIds.length > 0) {
                    sourceDeptIdList = Arrays.asList(sourceDeptIds);
                }
            } else {
                sourceDeptIdList.add(sourceDeptId);
            }
            if (sourceDeptIdList.size() > 0) {
                for (String string : sourceDeptIdList) {
                    lists = NetworkStreamCache.getStreamOfSourceDeptId(string);
                    if (lists.size() <= 0) continue;
                    for (NetworkStreamModel model : lists) {
                        if (model == null || !sourceTypeList.contains(model.getSourceType())) continue;
                        streamList.add(model);
                    }
                }
            }
        }
        return streamList;
    }

    public static Iterator<NetworkStreamModel> getStreamOfTopic(String topicName) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_TopicIndex.class, (Serializable)((Object)topicName), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfTopic(String topicName) {
        return Cache.iteratorToList(NetworkStreamCache.getStreamOfTopic(topicName));
    }

    public static Iterator<NetworkStreamModel> getStreamOfAtUser(String userId) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_AtUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfAtUser(String userId) {
        return Cache.iteratorToList(NetworkStreamCache.getStreamOfAtUser(userId));
    }

    public static Iterator<NetworkStreamModel> getStreamOfCreateUser(String userId) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_CreateUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfCreateUser(String userId) {
        return Cache.iteratorToList(NetworkStreamCache.getStreamOfCreateUser(userId));
    }

    public static Iterator<NetworkStreamModel> getStreamOfPraiseUser(String userId) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_PraiseUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfPraiseUser(String userId) {
        return Cache.iteratorToList(NetworkStreamCache.getStreamOfPraiseUser(userId));
    }

    public static Iterator<NetworkStreamModel> getStreamOfNotifier(String userId) {
        return NetworkStreamCache.getCache().getByIndex(NetworkStream_NotifierUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME);
    }

    public static List<NetworkStreamModel> loadStreamOfNotifier(String userId) {
        return Cache.iteratorToList(NetworkStreamCache.getStreamOfNotifier(userId));
    }

    public static List<NetworkStreamModel> getStreamOfSourceId(String sourceId) {
        List<NetworkStreamModel> chilerdList;
        ArrayList<NetworkStreamModel> networkStreamList = new ArrayList<NetworkStreamModel>();
        Iterator iterators = NetworkStreamCache.getCache().getByIndex(NetworkStream_SourceIndex.class, (Serializable)((Object)sourceId), SORT_CREATETIME);
        List lists = Cache.iteratorToList((Iterator)iterators);
        if (lists.size() > 0) {
            networkStreamList.addAll(lists);
        }
        if ((chilerdList = NetworkStreamCache.getStreamOfParentSourceId(sourceId)).size() > 0) {
            networkStreamList.addAll(chilerdList);
        }
        return networkStreamList;
    }

    public static List<String> loadStreamChannelType() {
        ArrayList<String> channelTypeList = new ArrayList<String>();
        List<NetworkStreamModel> lists = NetworkStreamCache.loadNetworkStream();
        if (lists.size() > 0) {
            for (NetworkStreamModel model : lists) {
                if (model == null || UtilString.isEmpty((String)model.getChannelType()) || channelTypeList.contains(model.getChannelType())) continue;
                channelTypeList.add(model.getChannelType());
            }
        }
        return channelTypeList;
    }

    public static List<NetworkStreamModel> getStreamOfSourceType(String sourceType) {
        Iterator iterators = NetworkStreamCache.getCache().getByIndex(NetworkStream_SourceTypeIndex.class, (Serializable)((Object)sourceType), SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iterators);
    }

    public static List<NetworkStreamModel> getStreamBySourceType(String sourceType) {
        ArrayList<NetworkStreamModel> streamList = new ArrayList<NetworkStreamModel>();
        if (!UtilString.isEmpty((String)sourceType)) {
            List<String> sourceTypeList = new ArrayList<String>();
            if (sourceType.indexOf(",") > -1) {
                String[] sourceTypes = sourceType.split(",");
                if (sourceTypes.length > 0) {
                    sourceTypeList = Arrays.asList(sourceTypes);
                }
            } else {
                sourceTypeList.add(sourceType);
            }
            if (sourceTypeList.size() > 0) {
                for (String type : sourceTypeList) {
                    List<NetworkStreamModel> lists = NetworkStreamCache.getStreamOfSourceType(type);
                    if (lists.size() <= 0) continue;
                    streamList.addAll(lists);
                }
            }
        }
        return streamList;
    }

    public static List<NetworkStreamModel> getStreamOfSourceDeptId(String sourceDeptId) {
        Iterator iterators = NetworkStreamCache.getCache().getByIndex(NetworkStream_SourceDeptIndex.class, (Serializable)((Object)sourceDeptId), SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iterators);
    }

    public static List<NetworkStreamModel> getStreamOfParentSourceId(String parentSourceId) {
        ArrayList<NetworkStreamModel> streamModelList = new ArrayList<NetworkStreamModel>();
        Iterator iterators = NetworkStreamCache.getCache().getByIndex(NetworkStream_ParentSourceIndex.class, (Serializable)((Object)parentSourceId), SORT_CREATETIME);
        List lists = Cache.iteratorToList((Iterator)iterators);
        if (lists.size() > 0) {
            for (NetworkStreamModel model : lists) {
                if (model.getSourceId().equals(parentSourceId)) continue;
                streamModelList.add(model);
            }
        }
        return streamModelList;
    }

    public static List<NetworkStreamModel> loadNetworkStream() {
        Iterator iter = NetworkStreamCache.getCache().iterator();
        return Cache.iteratorToList((Iterator)iter);
    }

    public void load() {
        List<NetworkStreamModel> list = new NetworkStreamDao().loadNetworkStreamOfCache();
        for (NetworkStreamModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u4fe1\u606f\u6d41 [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkStreamCache getCache() {
        return (NetworkStreamCache)CacheManager.getCache(NetworkStreamCache.class);
    }
}

