/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.cache.NetworkTopic_NameIndex;
import com.actionsoft.apps.network.cache.NetworkTopic_NetworkIndex;
import com.actionsoft.apps.network.cache.NetworkTopic_TeamIndex;
import com.actionsoft.apps.network.cache.NetworkTopic_UserIndex;
import com.actionsoft.apps.network.dao.NetworkTopicDao;
import com.actionsoft.apps.network.model.NetworkTopicModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilString;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class NetworkTopicCache
extends Cache<String, NetworkTopicModel> {
    public static final Comparator<NetworkTopicModel> SORT_CREATETIME = new Comparator<NetworkTopicModel>(){

        @Override
        public int compare(NetworkTopicModel o1, NetworkTopicModel o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };

    public NetworkTopicCache(CachePluginProfile profile) {
        super(profile);
        this.registeIndex(NetworkTopic_NetworkIndex.class, (CacheIndex)new NetworkTopic_NetworkIndex());
        this.registeIndex(NetworkTopic_TeamIndex.class, (CacheIndex)new NetworkTopic_TeamIndex());
        this.registeIndex(NetworkTopic_NameIndex.class, (CacheIndex)new NetworkTopic_NameIndex());
        this.registeIndex(NetworkTopic_UserIndex.class, (CacheIndex)new NetworkTopic_UserIndex());
    }

    public static void putModel(NetworkTopicModel model) {
        NetworkTopicModel old = NetworkTopicCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkTopicDao().insert(model) : new NetworkTopicDao().update(model);
        if (result == 1) {
            NetworkTopicCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkTopicModel getModel(String id) {
        return (NetworkTopicModel)((Object)NetworkTopicCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkTopicDao().delete(id);
        if (result == 1) {
            NetworkTopicCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static Iterator<NetworkTopicModel> getTopicOfNetwork(String networkId) {
        return NetworkTopicCache.getCache().getByIndex(NetworkTopic_NetworkIndex.class, (Serializable)((Object)networkId), SORT_CREATETIME);
    }

    public static List<NetworkTopicModel> loadTopicOfNetwork(String networkId) {
        return Cache.iteratorToList(NetworkTopicCache.getTopicOfNetwork(networkId));
    }

    public static Iterator<NetworkTopicModel> getTopicOfTeam(String teamId) {
        return NetworkTopicCache.getCache().getByIndex(NetworkTopic_TeamIndex.class, (Serializable)((Object)teamId), SORT_CREATETIME);
    }

    public static List<NetworkTopicModel> loadTopicOfUser(String userId) {
        return Cache.iteratorToList(NetworkTopicCache.getTopicOfUser(userId));
    }

    public static Iterator<NetworkTopicModel> getTopicOfUser(String userId) {
        return NetworkTopicCache.getCache().getByIndex(NetworkTopic_UserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME);
    }

    public static List<NetworkTopicModel> loadTopicOfTeam(String teamId) {
        return Cache.iteratorToList(NetworkTopicCache.getTopicOfTeam(teamId));
    }

    public static NetworkTopicModel getTopicByName(String topicName) {
        Iterator iter = NetworkTopicCache.getCache().getByIndex(NetworkTopic_NameIndex.class, (Serializable)((Object)topicName), SORT_CREATETIME);
        if (iter.hasNext()) {
            return (NetworkTopicModel)((Object)iter.next());
        }
        return null;
    }

    public static List<NetworkTopicModel> loadAllNetworkTopic() {
        Iterator iter = NetworkTopicCache.getCache().iteratorSorted(SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static NetworkTopicModel getModelByName(String topicName) {
        Iterator iter = NetworkTopicCache.getCache().iterator();
        while (iter.hasNext()) {
            NetworkTopicModel topic = (NetworkTopicModel)((Object)iter.next());
            if (!topic.getTopicName().equals(topicName)) continue;
            return topic;
        }
        return null;
    }

    public static NetworkTopicModel getModelByName(String topicName, String networkId, String teamId) {
        Iterator<NetworkTopicModel> iter = UtilString.isEmpty((String)teamId) ? NetworkTopicCache.getTopicOfNetwork(networkId) : NetworkTopicCache.getTopicOfTeam(teamId);
        if (iter == null) {
            return null;
        }
        while (iter.hasNext()) {
            NetworkTopicModel topic = iter.next();
            if (!topic.getTopicName().equals(topicName)) continue;
            return topic;
        }
        return null;
    }

    public static Map<String, NetworkTopicModel> vailModelByName(List<String> topicNames, String networkId, String teamId) {
        teamId = "";
        HashMap<String, NetworkTopicModel> topicResult = new HashMap<String, NetworkTopicModel>();
        Iterator<NetworkTopicModel> iter = UtilString.isEmpty((String)teamId) ? NetworkTopicCache.getTopicOfNetwork(networkId) : NetworkTopicCache.getTopicOfTeam(teamId);
        if (iter == null) {
            return null;
        }
        while (iter.hasNext()) {
            NetworkTopicModel topic = iter.next();
            if (!topicNames.contains(topic.getTopicName())) continue;
            topicResult.put(topic.getTopicName(), topic);
            topicNames.remove(topic.getTopicName());
        }
        for (String topicName : topicNames) {
            topicResult.put(topicName, null);
        }
        return topicResult;
    }

    public void load() {
        List<NetworkTopicModel> list = new NetworkTopicDao().loadNetworkTopicOfCache();
        for (NetworkTopicModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u8bdd\u9898 [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkTopicCache getCache() {
        return (NetworkTopicCache)CacheManager.getCache(NetworkTopicCache.class);
    }
}

