/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkStreamCommentDao
extends DaoObject<NetworkStreamCommentModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkStreamCommentDao.class);

    public List<NetworkStreamCommentModel> loadNetworkStreamCommentOfCache() {
        List<NetworkStreamCommentModel> list = new ArrayList<NetworkStreamCommentModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM ").append(this.entityName());
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkStreamCommentModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public String entityName() {
        return "APP_ACT_NETWORK_STREAM_COMMENT";
    }

    public int insert(NetworkStreamCommentModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("STREAMID", model.getStreamId());
        if (model.getTransStreamId() != null) {
            paramsMap.put("TRANSSTREAMID", model.getTransStreamId());
        }
        paramsMap.put("COMMENTTYPE", model.getCommentType());
        paramsMap.put("COMMENTCONTENT", model.getCommentContent());
        paramsMap.put("IPADDRESS", model.getIpAddress());
        paramsMap.put("DEVICETYPE", model.getDeviceType());
        paramsMap.put("COMMENTID", model.getCommentId());
        paramsMap.put("CREATEUSERID", model.getCreateUserId());
        paramsMap.put("CREATEUSERNAME", model.getCreateUserName());
        paramsMap.put("CREATETIME", model.getCreateTime());
        paramsMap.put("ISANONYMITY", model.getIsAnonymity());
        return DBSql.update((String)DBSql.getInsertStatement((String)this.entityName(), paramsMap), paramsMap);
    }

    public int update(NetworkStreamCommentModel model) throws AWSDataAccessException {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("STREAMID", model.getStreamId());
        if (model.getTransStreamId() != null) {
            paramsMap.put("TRANSSTREAMID", model.getTransStreamId());
        }
        paramsMap.put("COMMENTTYPE", model.getCommentType());
        paramsMap.put("COMMENTCONTENT", model.getCommentContent());
        paramsMap.put("IPADDRESS", model.getIpAddress());
        paramsMap.put("DEVICETYPE", model.getDeviceType());
        paramsMap.put("COMMENTID", model.getCommentId());
        paramsMap.put("ISANONYMITY", model.getIsAnonymity());
        return super.update((Object)model.getId(), paramsMap);
    }

    public RowMapper<NetworkStreamCommentModel> rowMapper() {
        return new NetworkStreamCommentModelRowMapper();
    }

    private static class NetworkStreamCommentModelRowMapper
    implements RowMapper<NetworkStreamCommentModel> {
        private NetworkStreamCommentModelRowMapper() {
        }

        public NetworkStreamCommentModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkStreamCommentModel model = new NetworkStreamCommentModel();
            model.setId(rs.getString("ID"));
            model.setStreamId(rs.getString("STREAMID"));
            model.setTransStreamId(rs.getString("TRANSSTREAMID"));
            model.setCommentType(rs.getString("COMMENTTYPE"));
            model.setCommentContent(rs.getString("COMMENTCONTENT"));
            model.setAttached(rs.getString("ATTACHED"));
            model.setIpAddress(rs.getString("IPADDRESS"));
            model.setDeviceType(rs.getString("DEVICETYPE"));
            model.setCommentId(rs.getString("COMMENTID"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setIsAnonymity(rs.getString("ISANONYMITY"));
            return model;
        }
    }
}

