/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.helper;

import com.actionsoft.apps.network.helper.AttachementFile;
import com.actionsoft.apps.network.helper.StreamContent;
import com.actionsoft.apps.network.helper.StreamContentNotice;
import com.actionsoft.apps.network.helper.StreamContentPraise;
import com.actionsoft.apps.network.helper.StreamContentQuestion;
import com.actionsoft.apps.network.util.HttpUtil;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.RuleAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamContentHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamContentHelper.class);

    public static StreamContent format(String streamContent, int streamType, UserContext ctx) {
        boolean bool = NetworkDataUtil.isJson(streamContent);
        if (!bool) {
            return null;
        }
        StreamContent sc = null;
        JSONObject json = JSONObject.parseObject((String)streamContent);
        ArrayList<AttachementFile> fileList = new ArrayList<AttachementFile>();
        if (json.get((Object)"attachement") != null && !UtilString.isEmpty((String)json.getString("attachement"))) {
            JSONArray files = JSONArray.parseArray((String)UtilJson.optString((JSONObject)json, (String)"attachement"));
            int len = files.size();
            for (int i = 0; i < len; ++i) {
                AttachementFile file = (AttachementFile)JSONObject.toJavaObject((JSON)files.getJSONObject(i), AttachementFile.class);
                fileList.add(file);
            }
        }
        json.remove((Object)"attachement");
        Object link = UtilJson.optString((JSONObject)json, (String)"link");
        String linkTitle = UtilJson.optString((JSONObject)json, (String)"linkTitle");
        String linkDescription = "";
        if (!UtilString.isEmpty((String)link)) {
            if (!(((String)link).startsWith("http://") || ((String)link).startsWith("https://") || ((String)link).startsWith("@portal"))) {
                link = "http://" + (String)link;
            }
            try {
                RuleAPI ruleApi = SDK.getRuleAPI();
                String actLink = ruleApi.executeAtScript((String)link, ctx);
                HtmlPage page = HttpUtil.getHtmlPage(actLink);
                linkTitle = page.getTitleText();
                if (UtilString.isEmpty((String)linkTitle)) {
                    linkTitle = "\u67e5\u770b\u8be6\u60c5";
                }
                DomNodeList metas = page.getElementsByTagName("meta");
                for (HtmlElement meta : metas) {
                    String name = meta.getAttribute("name");
                    if (!name.toLowerCase().equals("description")) continue;
                    linkDescription = meta.getAttribute("content");
                    break;
                }
                if (linkDescription == null) {
                    linkDescription = page.getBody().asText();
                }
                linkDescription = HttpUtil.getSubString(linkDescription, 300, "...");
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                linkTitle = link;
            }
            json.put("link", link);
            json.put("linkTitle", (Object)linkTitle);
            json.put("linkDescription", (Object)linkDescription);
        }
        switch (streamType) {
            case 1: 
            case 2: {
                sc = (StreamContent)JSONObject.toJavaObject((JSON)json, StreamContent.class);
                break;
            }
            case 3: {
                sc = (StreamContentNotice)JSONObject.toJavaObject((JSON)json, StreamContentNotice.class);
                break;
            }
            case 4: {
                sc = (StreamContentPraise)JSONObject.toJavaObject((JSON)json, StreamContentPraise.class);
                break;
            }
            default: {
                sc = (StreamContent)JSONObject.toJavaObject((JSON)json, StreamContent.class);
            }
        }
        sc.setAttachement(fileList);
        return sc;
    }

    public static String format(int streamType, String content) {
        return StreamContentHelper.format(streamType, content, "", "", "", "", "", "", "", "", "", null);
    }

    public static String format(int streamType, String content, String attachement, String link, String tags, String notifier, String notifierTeam, String title, String praisePeople, String praiseBadge, String pariseDefinition, UserContext ctx) {
        JSONArray fileArray;
        JSONObject json = new JSONObject();
        ArrayList<AttachementFile> fileList = new ArrayList<AttachementFile>();
        if (NetworkDataUtil.isJson(attachement) && (fileArray = JSONArray.parseArray((String)attachement)) != null) {
            int len = fileArray.size();
            for (int i = 0; i < len; ++i) {
                JSONObject obj = fileArray.getJSONObject(i);
                AttachementFile file = (AttachementFile)JSONObject.toJavaObject((JSON)obj, AttachementFile.class);
                String fileUUID = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
                file.setFileUUID(fileUUID);
                file.setFileType(file.getFileType().toLowerCase());
                fileList.add(file);
            }
        }
        String linkTitle = "";
        String linkDescription = "";
        if (!UtilString.isEmpty((String)link)) {
            if (!(((String)link).startsWith("http://") || ((String)link).startsWith("https://") || ((String)link).startsWith("@portal"))) {
                link = "http://" + (String)link;
            }
            try {
                RuleAPI ruleApi = SDK.getRuleAPI();
                String actLink = ruleApi.executeAtScript((String)link, ctx);
                HtmlPage page = HttpUtil.getHtmlPage(actLink);
                linkTitle = page.getTitleText();
                if (UtilString.isEmpty((String)linkTitle)) {
                    linkTitle = "\u67e5\u770b\u8be6\u60c5";
                }
                DomNodeList metas = page.getElementsByTagName("meta");
                for (HtmlElement meta : metas) {
                    String name = meta.getAttribute("name");
                    if (!name.toLowerCase().equals("description")) continue;
                    linkDescription = meta.getAttribute("content");
                    break;
                }
                if (linkDescription == null) {
                    linkDescription = page.getBody().asText();
                }
                linkDescription = HttpUtil.getSubString(linkDescription, 300, "...");
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                linkTitle = link;
            }
        }
        switch (streamType) {
            case 1: 
            case 2: {
                StreamContentQuestion sc = new StreamContentQuestion();
                sc.setContent(content);
                sc.setContentSize(content.length());
                sc.setLink((String)link);
                sc.setLinkTitle(linkTitle);
                sc.setLinkDescription(linkDescription);
                sc.setTags(tags);
                sc.setNotifier(notifier);
                sc.setNotifierTeam(notifierTeam);
                sc.setAttachement(fileList);
                json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sc));
                break;
            }
            case 3: 
            case 5: {
                StreamContentNotice scn = new StreamContentNotice();
                scn.setContent(content);
                scn.setContentSize(content.length());
                scn.setLink((String)link);
                scn.setLinkTitle(linkTitle);
                scn.setLinkDescription(linkDescription);
                scn.setTags(tags);
                scn.setNotifier(notifier);
                scn.setNotifierTeam(notifierTeam);
                scn.setAttachement(fileList);
                scn.setTitle(title);
                json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)scn));
                break;
            }
            case 4: {
                StreamContentPraise scp = new StreamContentPraise();
                scp.setContent(content);
                scp.setContentSize(content.length());
                scp.setLink((String)link);
                scp.setLinkTitle(linkTitle);
                scp.setLinkDescription(linkDescription);
                scp.setTags(tags);
                scp.setNotifier(notifier);
                scp.setNotifierTeam(notifierTeam);
                scp.setAttachement(fileList);
                scp.setPraisePeople(praisePeople);
                scp.setPraiseBadge(praiseBadge);
                scp.setPariseDefinition(pariseDefinition);
                json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)scp));
                break;
            }
            default: {
                StreamContent sc = new StreamContent();
                sc.setContent(content);
                sc.setLink((String)link);
                sc.setLinkTitle(linkTitle);
                sc.setLinkDescription(linkDescription);
                sc.setTags(tags);
                sc.setNotifier(notifier);
                sc.setNotifierTeam(notifierTeam);
                sc.setAttachement(fileList);
                json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sc));
            }
        }
        return json.toString();
    }

    public static void main(String[] args) {
    }
}

