/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.mydriver;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.file.ReadDCFile;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MydriverTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MydriverTool.class);

    public ResponseObject storage(String sid, String fileActName, DCContext dcCtx, int fileSize) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext networkApp = appAPI.getAppContext("com.actionsoft.apps.mydriver");
        if (networkApp != null && SDK.getAppAPI().isActive(networkApp.getId())) {
            String fileData = "";
            try {
                InputStream is1 = ReadDCFile.getInstance().read(dcCtx);
                if (is1 == null) {
                    LOGGER.error("network is1 is null");
                    ro.err("InputStream is null");
                }
                ByteArrayOutputStream swapStream1 = new ByteArrayOutputStream();
                byte[] buf1 = new byte[1024];
                int rc1 = 0;
                while ((rc1 = is1.read(buf1, 0, 1024)) > 0) {
                    swapStream1.write(buf1, 0, rc1);
                }
                byte[] bytedata = swapStream1.toByteArray();
                fileData = new String(Base64.encode((byte[])bytedata));
                LOGGER.error("network fileData:" + fileData);
                LOGGER.error("network fileData:" + fileData.length());
            }
            catch (IOException e) {
                LOGGER.error("network 01" + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            String aslp = "aslp://com.actionsoft.apps.mydriver/createMyDriverFileByData";
            HashMap<String, Object> params = new HashMap<String, Object>();
            try {
                params.put("sid", sid);
                params.put("fileName", fileActName);
                params.put("fileSize", fileSize);
                params.put("data", fileData);
                LOGGER.error("network params sid" + sid);
                LOGGER.error("network params fileName" + fileActName);
                LOGGER.error("network params fileSize" + fileSize);
                LOGGER.error("network callASLP" + aslp);
                ro = appAPI.callASLP(networkApp, aslp, params);
                LOGGER.error("network after call" + ro.toDataString());
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)networkApp, (String)ro.getMsg());
                    LOGGER.error("network:" + ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                ro.err(e.getMessage());
            }
        } else {
            return ResponseObject.newErrResponse().msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u672a\u5b89\u88c5\u4f01\u4e1a\u7f51\u76d8"));
        }
        LOGGER.error("network\uff1a" + ro.toDataString());
        return ro;
    }

    public ResponseObject unfavorite(String commentId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext favoriteApp = appAPI.getAppContext("com.actionsoft.apps.favorite");
        AppContext networkApp = appAPI.getAppContext("com.actionsoft.apps.network");
        if (favoriteApp != null && SDK.getAppAPI().isActive(favoriteApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.favorite/unfavorite";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("id", commentId);
                ro = appAPI.callASLP(networkApp, aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)networkApp, (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }
}

