/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternUtil.class);

    public static List<String> matcherAtUserAliasName(String content) {
        Pattern pattern = Pattern.compile("@[\u4e00-\u9fa5\\.@\\w\\d- ]{1,}<[\u4e00-\u9fa5\\.@\\w\\d- @]{1,}>");
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String temp = matcher.group().replaceFirst("@", "");
            if (list.contains(temp)) continue;
            list.add(temp);
        }
        return list;
    }

    public static List<String> matcherUserAliasName(String content) {
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5\\.@\\w\\d- ]{1,}<[\u4e00-\u9fa5\\.@\\w\\d- ]{1,}>");
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String temp = matcher.group().replaceFirst("@", "");
            if (list.contains(temp)) continue;
            list.add(temp);
        }
        return list;
    }

    public static String matcherAtUserAliasNameStr(String content) {
        List<String> list = PatternUtil.matcherAtUserAliasName(content);
        Object result = "";
        for (String val : list) {
            result = (String)result + val + " ";
        }
        result = ((String)result).length() > 0 ? ((String)result).substring(0, ((String)result).length() - 1) : result;
        return result;
    }

    public static List<String> matcherTopic(String content) {
        return PatternUtil.matcher(content, "#[\u4e00-\u9fa5\\w\\d- ,.<>\uff0c\u3002\u300a\u300b\u3010\u3011\uff1f]{1,}#");
    }

    public static List<String> matcherLink(String content) {
        return PatternUtil.matcher(content, "http://[* ]{1,}#");
    }

    public static List<String> matcher(String content, String regExp) {
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String temp = matcher.group();
            if (list.contains(temp)) continue;
            list.add(temp);
        }
        return list;
    }

    public static void main(String[] args) {
        String str = "@wangsz<\u738b\u6c34\u829d> @lisi<\u674e\u65af>@zhangsan2<\u5f20\u4e092> ss@\u7ba1\u7406\u5458 @admin  ,aaa<ddd>";
        str = "@admin<\u7ba1\u7406\u5458> @test@actionsoft.com.cn<test\u5e26@\u5e26.\u7b26\u53f7> ";
        List<String> list = PatternUtil.matcherUserAliasName(str);
        str = PatternUtil.matcherAtUserAliasNameStr(str);
        LOGGER.info(str);
    }
}

