/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.event;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.core.delegate.ProcessExecutionContext;
import com.actionsoft.bpms.bpmn.engine.listener.ExecuteListener;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.BPMNError;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.awspaas.user.apps.donenow_ctt.service.wareHouseProductService;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class costPickFormAfterSave
extends ExecuteListener {
    public String getDescription() {
        return "\u5408\u540c\u4ea7\u54c1\u62e3\u8d27\u4fdd\u5b58\u540e";
    }

    public void execute(ProcessExecutionContext processExecutionContext) throws Exception {
        BO pickBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT_PRODUCT_PICK", processExecutionContext.getProcessInstance().getId());
        String warehouseProductId = pickBO.getString("WAREHOUSE_PRODUCT_ID");
        String contractCostId = pickBO.getString("CONTRACT_COST_ID");
        LinkedHashSet<String> pickSerials = new LinkedHashSet<String>();
        String pick_sns = pickBO.getString("SERIAL_NUMBERS");
        String PICKED_SNS = pickBO.getString("PICKED_SNS");
        if (StringUtils.isNotBlank((CharSequence)PICKED_SNS)) {
            String normalizedOriginals = StringUtils.defaultString((String)pick_sns, (String)"");
            String combined = normalizedOriginals.isEmpty() ? PICKED_SNS : PICKED_SNS + "," + normalizedOriginals;
            for (String serial : combined.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)serial)) continue;
                pickSerials.add(serial);
            }
            pick_sns = StringUtils.join(pickSerials, (String)",");
            pickBO.set("SERIAL_NUMBERS", (Object)pick_sns);
        }
        int PICK_QUANTITY = this.ObjToInt(pickBO.get("PICK_QUANTITY"));
        int warehouseProductAvailableQuantity = this.ObjToInt(DBSql.getString((String)"SELECT SUM(AVAILABLE) FROM VIEW_EU_DNINVT_PRODUCT_INVENTORY where ID=?", (Object[])new Object[]{warehouseProductId}));
        if (warehouseProductAvailableQuantity <= 0) {
            throw new BPMNError("", "\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
        if (PICK_QUANTITY > warehouseProductAvailableQuantity) {
            throw new BPMNError("", "\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
        int contractCostQuantity = this.ObjToInt(SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", contractCostId, "QUANTITY"));
        int contractProductPickQuantity = this.ObjToInt(DBSql.getString((String)"SELECT SUM(QUANTITY) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=?  AND CLOSED=0", (Object[])new Object[]{contractCostId}));
        if (contractProductPickQuantity + PICK_QUANTITY > contractCostQuantity) {
            throw new BPMNError("", "\u62e3\u8d27\u6570\u91cf\u8d85\u51fa\u5408\u540c\u6570\u91cf");
        }
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            String WAREHOUSE_ID = pickBO.getString("WAREHOUSE_ID");
            int STATUS_ID = 2157;
            if (pickBO.getString("PICK_TYPE").equals("1")) {
                String resWareId = DBSql.getString((Connection)conn, (String)"SELECT ID FROM BO_EU_DNIVT_WAREHOUSE WHERE RESOURCE_ID=? AND CLOSED=0 ", (Object[])new Object[]{processExecutionContext.getUserContext().getUID()});
                if (StringUtils.isNotBlank((CharSequence)resWareId)) {
                    WAREHOUSE_ID = resWareId;
                } else {
                    BO resWare = new BO();
                    resWare.set("NAME", (Object)("\u5458\u5de5\uff1a" + processExecutionContext.getUserContext().getUserName()));
                    ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_e10413dd6e034d22aac787a35917814c", processExecutionContext.getUserContext().getUID(), "\u521b\u5efa\u5458\u5de5\u4ed3\u5e93" + resWare.getString("NAME"));
                    resWare.setBindId(processInstance.getId());
                    resWare.set("IS_DEFAULT", (Object)0);
                    resWare.set("IS_ACTIVE", (Object)1);
                    resWare.set("RESOURCE_ID", (Object)processExecutionContext.getUserContext().getUID());
                    SDK.getBOAPI().create("BO_EU_DNIVT_WAREHOUSE", resWare, processInstance, processExecutionContext.getUserContext(), conn);
                    WAREHOUSE_ID = resWare.getId();
                }
            } else if (pickBO.getString("PICK_TYPE").equals("2")) {
                STATUS_ID = 2159;
            }
            BO costProductBO = new BO();
            ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_6bc913271069455abbd516c556b26d31", processExecutionContext.getUserContext().getUID(), "\u5408\u540c\u4ea7\u54c1\u7269\u6d41\u7ba1\u7406");
            costProductBO.setBindId(processInstance.getId());
            costProductBO.set("WAREHOUSE_ID", (Object)WAREHOUSE_ID);
            costProductBO.set("CONTRACT_COST_ID", (Object)contractCostId);
            costProductBO.set("QUANTITY", pickBO.get("PICK_QUANTITY"));
            costProductBO.set("SN", (Object)pick_sns);
            costProductBO.set("STATUS_ID", (Object)STATUS_ID);
            costProductBO.set("OLD_QUANTITY", costProductBO.get("QUANTITY"));
            SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProductBO, processInstance, processExecutionContext.getUserContext(), conn);
            int contractCostStatusId = 0;
            contractCostQuantity = this.ObjToInt(((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_COST").connection(conn)).detailByField(contractCostId, "QUANTITY"));
            contractProductPickQuantity = this.ObjToInt(DBSql.getString((Connection)conn, (String)"SELECT SUM(QUANTITY) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=? AND CLOSED=0", (Object[])new Object[]{contractCostId}));
            if (contractCostQuantity == contractProductPickQuantity) {
                contractCostStatusId = DBSql.getInt((Connection)conn, (String)"SELECT COUNT(1) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=? AND CLOSED=0 AND STATUS_ID=?", (Object[])new Object[]{contractCostId, 2156}) > 0 ? 1235 : (DBSql.getInt((Connection)conn, (String)"SELECT COUNT(1) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=? AND CLOSED=0 AND STATUS_ID<>? AND STATUS_ID<>?", (Object[])new Object[]{contractCostId, 2157, 2158}) == 0 ? 1236 : (DBSql.getInt((Connection)conn, (String)"SELECT COUNT(1) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=? AND CLOSED=0 AND STATUS_ID<>? ", (Object[])new Object[]{contractCostId, 2159}) == 0 ? 1237 : 1236));
            } else if (DBSql.getInt((Connection)conn, (String)"SELECT DOES_NOT_REQUIRE_PROCUREMENT FROM BO_EU_DNIVT_PRODUCT WHERE ID=?", (Object[])new Object[]{pickBO.getString("PRODUCT_ID")}) == 1) {
                contractCostStatusId = 1234;
            }
            if (contractCostStatusId != 0) {
                DBSql.update((Connection)conn, (String)"UPDATE BO_EU_DNCTT_CONTRACT_COST SET STATUS_ID=? WHERE ID=?", (Object[])new Object[]{contractCostStatusId, contractCostId});
            }
            if (pickBO.getString("PICK_TYPE").equals("1")) {
                wareHouseProductService.getInstance().transfer(processExecutionContext.getUserContext(), conn, pickBO.getString("PRODUCT_ID"), pickBO.getString("WAREHOUSE_ID"), WAREHOUSE_ID, this.ObjToInt(pickBO.get("PICK_QUANTITY")), pick_sns, 1481, null);
            } else if (pickBO.getString("PICK_TYPE").equals("2")) {
                BO costBO = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_COST").connection(conn)).addQuery("ID=", (Object)pickBO.getString("CONTRACT_COST_ID"))).detail();
                HashMap<String, Object> ivtTransfer = new HashMap<String, Object>();
                ivtTransfer.put("TO_ACCOUNT_ID", costBO.get("ACCOUNT_ID"));
                ivtTransfer.put("TO_CONTRACT_ID", costBO.get("CONTRACT_ID"));
                ivtTransfer.put("TO_PROJECT_ID", costBO.get("PROJECT_ID"));
                ivtTransfer.put("TO_TASK_ID", costBO.get("TASK_ID"));
                wareHouseProductService.getInstance().transfer(processExecutionContext.getUserContext(), conn, pickBO.getString("PRODUCT_ID"), pickBO.getString("WAREHOUSE_ID"), null, this.ObjToInt(pickBO.get("PICK_QUANTITY")), pick_sns, 1482, ivtTransfer);
            }
            String sql = "SELECT a.QUANTITY-SUM(ifnull(b.QUANTITY,0)) FROM BO_EU_DNCTT_CONTRACT_COST a LEFT JOIN BO_EU_DNCTT_CONTRACT_COST_PRODUCT b ON a.ID=b.CONTRACT_COST_ID AND b.CLOSED = 0 WHERE a.ID=?";
            if (DBSql.getInt((Connection)conn, (String)sql, (Object[])new Object[]{contractCostId}) <= 0) {
                BO costBO = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_COST").connection(conn)).addQuery("ID=", (Object)contractCostId)).detail();
                if (DBSql.getInt((Connection)conn, (String)"select count(ID) from BO_EU_DNCTT_CONTRACT_COST_PRODUCT where CONTRACT_COST_ID=? AND STATUS_ID=2156  AND CLOSED=0", (Object[])new Object[]{contractCostId}) > 0) {
                    costBO.set("STATUS_ID", (Object)1235);
                } else if (DBSql.getInt((Connection)conn, (String)"select count(ID) from BO_EU_DNCTT_CONTRACT_COST_PRODUCT where CONTRACT_COST_ID=? AND (STATUS_ID=2158 OR STATUS_ID=2157)  AND CLOSED=0", (Object[])new Object[]{contractCostId}) > 0) {
                    costBO.set("STATUS_ID", (Object)1236);
                } else {
                    costBO.set("STATUS_ID", (Object)1237);
                }
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", costBO, conn);
            }
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            throw new BPMNError("550", "\u5e93\u5b58\u8f6c\u79fb\u5931\u8d25");
        }
        finally {
            DBSql.close((Connection)conn);
        }
    }

    private int ObjToInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        String objStr = obj.toString();
        if (objStr.equals("")) {
            return 0;
        }
        if (objStr.contains(".")) {
            objStr = objStr.substring(0, objStr.indexOf("."));
        }
        return Integer.parseInt(objStr);
    }
}

