/*
 * Decompiled with CFR 0.152.
 */
package dn;

import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.core.delegate.ProcessExecutionContext;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.alibaba.fastjson.JSONObject;
import dn.DateUtil;
import dn.ObjectEqualsOptimized;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class recordFormChanges {
    private static final String[] excludesArray = new String[]{"ID", "ORGID", "BINDID", "CREATEDATE", "CREATEUSER", "UPDATEDATE", "UPDATEUSER", "PROCESSDEFID", "ISEND"};

    public static boolean execute(ProcessExecutionContext param) {
        UserContext uc = param.getUserContext();
        String boId = param.getParameterOfString("$BOID");
        String formId = param.getParameterOfString("$FORMID");
        String boName = param.getParameterOfString("$BONAME");
        BO formData = (BO)param.getParameter("$FORMDATA");
        recordFormChanges.record(uc, formData, "\u8868\u5355\u4fdd\u5b58");
        try {
            Object gridData = param.getParameter("$GRIDDATA");
            if (gridData != null) {
                List gridDataList = (List)gridData;
                for (BO rowData : gridDataList) {
                    recordFormChanges.record(uc, rowData, "\u8868\u5355\u4fdd\u5b58");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void record(UserContext uc, BO formData, String remark) {
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            recordFormChanges.record(uc, formData, remark, conn);
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            DBSql.close((Connection)conn);
        }
    }

    public static void record(UserContext uc, String boName, Map<String, Object> formData, String remark) {
        try {
            recordFormChanges.record(uc, boName, formData, remark, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void record(UserContext uc, String boName, Map<String, Object> formData, String remark, Connection conn) {
        if (formData == null || formData.isEmpty() || !formData.containsKey("ID") || formData.size() < 2) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)boName)) {
            return;
        }
        BOModel boModel = BOCache.getInstance().getModelByEntityName(boName);
        String ID = formData.get("ID").toString();
        BO bo = new BO();
        bo.setModel(boModel);
        bo.setId(ID);
        bo.setAll(formData);
        try {
            if (conn == null) {
                recordFormChanges.record(uc, bo, remark);
            } else {
                recordFormChanges.record(uc, bo, remark, conn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void record(UserContext uc, BO formData, String remark, Connection conn) {
        try {
            Map formDataMap = formData.asMap();
            BOModel boModel = formData.getModel();
            String boName = boModel.getName();
            String boId = formData.getId();
            boolean isCreate = true;
            BO orgBO = ((BOQueryAPI)SDK.getBOAPI().query(boName).connection(conn)).detailById(boId);
            Map orgBOMap = null;
            if (orgBO != null) {
                isCreate = false;
                orgBOMap = orgBO.asMap();
            }
            HashMap<String, String> OPER_DESCRIPTION = new HashMap<String, String>();
            HashMap<String, String> OPER_DESCRIPTION_TRANS = new HashMap<String, String>();
            for (Map.Entry entry2 : formDataMap.entrySet()) {
                String colName = (String)entry2.getKey();
                boolean isExclude = false;
                for (String key : excludesArray) {
                    if (!key.equals(colName)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) continue;
                try {
                    JSONObject jsonObject;
                    BOItemModel boItemModel = boModel.getItem(colName);
                    if (boItemModel == null) {
                        System.out.println("\u5b57\u6bb5\uff1a" + colName + "--\u67e5\u627e\u5931\u8d25");
                        continue;
                    }
                    System.out.println(boItemModel.toString());
                    String sql = null;
                    String componentSetting = boItemModel.getComponentSetting();
                    if (StringUtils.isNotBlank((CharSequence)componentSetting) && (jsonObject = JSONObject.parseObject((String)componentSetting)).containsKey((Object)"dataSource")) {
                        JSONObject dataSource = jsonObject.getJSONObject("dataSource");
                        if (dataSource.getString("type").equals("SQL") && StringUtils.isNotBlank((CharSequence)dataSource.getString("sqlget")) && !dataSource.getString("sqlget").equals("null")) {
                            sql = "select GROUP_CONCAT(" + dataSource.getString("sqlshow") + ") as showti from (" + dataSource.getString("sqlselect") + ") t where find_in_set(" + dataSource.getString("sqlget") + ",?)>0 ";
                            if (sql.contains("@")) {
                                sql = SDK.getRuleAPI().executeAtScript(sql, uc);
                            }
                            System.out.println("sql\uff1a" + sql);
                        } else if (dataSource.getString("type").equals("KEYDICT")) {
                            sql = "select GROUP_CONCAT(CNNAME) as showti from bo_act_dict_kv_item where DICTKEY='" + dataSource.getString("keydict") + "' and find_in_set(ITEMNO,?)>0 ";
                        } else {
                            System.out.println("\u672a\u914d\u7f6ecomponentSetting\uff1a" + componentSetting);
                        }
                    }
                    String NEWVALUE = Objects.toString(entry2.getValue(), "");
                    String NEWDISPLAYVALUE = null;
                    if (StringUtils.isNotBlank(sql) && StringUtils.isNotBlank((CharSequence)NEWVALUE)) {
                        NEWDISPLAYVALUE = DBSql.getString((Connection)conn, sql, (Object[])new Object[]{NEWVALUE});
                    }
                    String colTitle = boItemModel.getTitle();
                    if (!isCreate && orgBOMap.containsKey(colName)) {
                        if (ObjectEqualsOptimized.objectEquals(orgBOMap.get(colName), entry2.getValue())) continue;
                        String OLDVALUE = Objects.toString(orgBOMap.get(colName), "");
                        String OLDDISPLAYVALUE = null;
                        if (StringUtils.isNotBlank((CharSequence)sql) && StringUtils.isNotBlank((CharSequence)OLDVALUE)) {
                            OLDDISPLAYVALUE = DBSql.getString((Connection)conn, (String)sql, (Object[])new Object[]{OLDVALUE});
                        }
                        OLDVALUE = ObjectEqualsOptimized.formatForDisplay(OLDVALUE);
                        OLDDISPLAYVALUE = ObjectEqualsOptimized.formatForDisplay(OLDDISPLAYVALUE);
                        NEWVALUE = ObjectEqualsOptimized.formatForDisplay(NEWVALUE);
                        NEWDISPLAYVALUE = ObjectEqualsOptimized.formatForDisplay(NEWDISPLAYVALUE);
                        OPER_DESCRIPTION.put(colName, OLDVALUE + "\u2192" + NEWVALUE);
                        OPER_DESCRIPTION_TRANS.put(colTitle, (StringUtils.isBlank((CharSequence)OLDDISPLAYVALUE) ? OLDVALUE : OLDDISPLAYVALUE) + "\u2192" + (StringUtils.isBlank((CharSequence)NEWDISPLAYVALUE) ? NEWVALUE : NEWDISPLAYVALUE));
                        continue;
                    }
                    if (!isCreate) continue;
                    NEWVALUE = ObjectEqualsOptimized.formatForDisplay(NEWVALUE);
                    NEWDISPLAYVALUE = ObjectEqualsOptimized.formatForDisplay(NEWDISPLAYVALUE);
                    OPER_DESCRIPTION.put(colName, NEWVALUE);
                    OPER_DESCRIPTION_TRANS.put(colTitle, StringUtils.isBlank((CharSequence)NEWDISPLAYVALUE) ? NEWVALUE : NEWDISPLAYVALUE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!OPER_DESCRIPTION.isEmpty()) {
                ProcessInstance boProcessInstance = SDK.getProcessAPI().createBOProcessInstance("obj_f096df04847f4d3bbafa06dcb102b8b8", uc.getUID(), "\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e-" + boName + "\uff1a" + boId);
                BO logBO = new BO();
                logBO.setBindId(boProcessInstance.getId());
                logBO.set("USERID", (Object)uc.getUID());
                logBO.set("USERNAME", (Object)uc.getUserName());
                logBO.set("OPER_TIME", (Object)DateUtil.getCurrentDateTime());
                logBO.set("OPER_TYPE_ID", (Object)(isCreate ? "800" : "802"));
                logBO.set("OPER_OBJECT_ID", (Object)boId);
                logBO.set("OPER_OBJECT_BO", (Object)boName);
                logBO.set("OPER_OBJECT_BOTITLE", (Object)boModel.getTitle());
                logBO.set("OPER_DESCRIPTION", (Object)JSONObject.toJSONString(OPER_DESCRIPTION));
                String trans = OPER_DESCRIPTION_TRANS.entrySet().stream().map(entry -> (String)entry.getKey() + "\uff1a" + (String)entry.getValue()).collect(Collectors.joining("|"));
                logBO.set("OPER_DESCRIPTION_TRANS", (Object)trans);
                logBO.set("REMARK", (Object)remark);
                SDK.getBOAPI().create("BO_EU_DNSYS_OPER_LOG", logBO, boProcessInstance, uc, conn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

