/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.favorite;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(FavoriteTool.class);

    public ResponseObject favorite(String sid, String title, String commentId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext favoriteApp = appAPI.getAppContext("com.actionsoft.apps.favorite");
        AppContext networkApp = appAPI.getAppContext("com.actionsoft.apps.network");
        if (favoriteApp != null && SDK.getAppAPI().isActive(favoriteApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.favorite/favorite";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sid", sid);
                params.put("title", title);
                params.put("id", commentId);
                ro = appAPI.callASLP(networkApp, aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)networkApp, (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public ResponseObject unfavorite(String commentId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext favoriteApp = appAPI.getAppContext("com.actionsoft.apps.favorite");
        AppContext networkApp = appAPI.getAppContext("com.actionsoft.apps.network");
        if (favoriteApp != null && SDK.getAppAPI().isActive(favoriteApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.favorite/unfavorite";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("id", commentId);
                ro = appAPI.callASLP(networkApp, aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)networkApp, (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }
}

