/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.notification;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bpmn.engine.core.EngineDebug;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkNotification {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkNotification.class);

    public ResponseObject simpleNotificationMessage(String sender, String targetIds, String content, String level, String sourceId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
        if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
            String sourceAppId = "com.actionsoft.apps.network";
            String aslp = "aslp://com.actionsoft.apps.notification/sendMessage";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sender", sender);
                params.put("targetIds", targetIds);
                params.put("content", content);
                params.put("level", level);
                params.put("systemName", "\u5de5\u4f5c\u7f51\u7edc\u6d88\u606f\u63d0\u9192");
                ro = appAPI.callASLP(appAPI.getAppContext(sourceAppId), aslp, params);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public ResponseObject dynamicSimpleNotificationMessage(String sender, String targetIds, String content, String level, String sourceId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
        if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
            String sourceAppId = "com.actionsoft.apps.network";
            String aslp = "aslp://com.actionsoft.apps.notification/sendMessage";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sender", sender);
                params.put("targetIds", targetIds);
                params.put("content", content);
                params.put("level", level);
                params.put("systemName", "\u5de5\u4f5c\u7f51\u7edc\u52a8\u6001\u6d88\u606f\u63d0\u9192");
                ro = appAPI.callASLP(appAPI.getAppContext(sourceAppId), aslp, params);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public ResponseObject dynamicNotification(String sender, String targetIds, JSONObject content, String level, String sourceId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
        if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
            String sourceAppId = "com.actionsoft.apps.network";
            String aslp = "aslp://com.actionsoft.apps.notification/sendMessage";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sender", sender);
                params.put("targetIds", targetIds);
                params.put("content", content.toString());
                params.put("level", level);
                params.put("systemName", "\u5de5\u4f5c\u7f51\u7edc\u52a8\u6001\u63d0\u9192");
                params.put("sourceId", sourceId);
                ro = appAPI.callASLP(appAPI.getAppContext(sourceAppId), aslp, params);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public boolean complexNotificationMessage(String sender, String targetIds, JSONObject json, String level, String sourceId) {
        AppAPI appAPI = SDK.getAppAPI();
        AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
        if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
            String sourceAppId = "com.actionsoft.apps.network";
            String aslp = "aslp://com.actionsoft.apps.notification/sendMessage";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sender", sender);
                params.put("targetIds", targetIds);
                params.put("content", json.toString());
                params.put("level", level);
                params.put("systemName", "\u5c0f\u7ec4\u901a\u77e5");
                EngineDebug.info((Object)appAPI.callASLP(appAPI.getAppContext(sourceAppId), aslp, params).toString());
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean complexNotificationVoteMessage(String sender, String targetIds, JSONObject json, String level) {
        AppAPI appAPI = SDK.getAppAPI();
        AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
        if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
            String sourceAppId = "com.actionsoft.apps.network";
            String aslp = "aslp://com.actionsoft.apps.notification/sendMessage";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sender", sender);
                params.put("targetIds", targetIds);
                params.put("content", json.toString());
                params.put("level", level);
                params.put("systemName", "\u6295\u7968\u901a\u77e5");
                EngineDebug.info((Object)appAPI.callASLP(appAPI.getAppContext(sourceAppId), aslp, params).toString());
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

