/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.extend;

import com.actionsoft.apps.network.extend.SignalTeamDeleted;
import com.actionsoft.apps.network.extend.TeamAppProfile;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.htmlframework.AlertWindow;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TeamAppManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppManager.class);
    private static List<TeamAppProfile> _list = new ArrayList<TeamAppProfile>();

    private TeamAppManager() {
    }

    public static void register(AppContext app, String title, String mainClass, String icon, String desc, String deletedClass, String subApps) {
        TeamAppProfile profile = new TeamAppProfile();
        profile.setDeletedClass(deletedClass);
        profile.setMainClass(mainClass);
        profile.setTitle(title);
        profile.setIcon(icon);
        profile.setDesc(desc);
        profile.setSubApps(subApps);
        profile.setAppContext(app);
        boolean isUpdate = false;
        for (TeamAppProfile p : _list) {
            if (!p.getId().equals(profile.getId())) continue;
            p = profile;
            isUpdate = true;
            SDK.getAppAPI().info(SDK.getAppAPI().getAppContext("com.actionsoft.apps.network"), "\u6269\u5c55App[" + profile.getTitle() + "]\u91cd\u65b0\u88ab\u6ce8\u518c");
            break;
        }
        if (!isUpdate) {
            _list.add(profile);
            SDK.getAppAPI().info(SDK.getAppAPI().getAppContext("com.actionsoft.apps.network"), "\u6269\u5c55App[" + profile.getTitle() + "]\u6ce8\u518c\u6210\u529f");
        }
    }

    public static TeamAppProfile getProfile(String id) {
        for (TeamAppProfile p : _list) {
            if (!p.getId().equals(id.trim())) continue;
            return p;
        }
        return null;
    }

    public static TeamAppProfile getProfile(String appId, String title) {
        for (TeamAppProfile p : _list) {
            if (!p.getAppContext().getId().equals(appId) || !p.getTitle().equals(title)) continue;
            return p;
        }
        return null;
    }

    public static List<TeamAppProfile> getList() {
        ArrayList<TeamAppProfile> list = new ArrayList<TeamAppProfile>();
        for (TeamAppProfile p : _list) {
            if (!SDK.getAppAPI().isActive(p.getAppContext().getId())) continue;
            list.add(p);
        }
        return list;
    }

    public static String callMainClass(UserContext context, String extendAppProfileId, String teamId) {
        TeamAppProfile profile = TeamAppManager.getProfile(extendAppProfileId);
        if (profile == null) {
            return AlertWindow.getWarningMessagePage((String)"\u8b66\u544a", (String)"\u8981\u6267\u884c\u7684\u5e94\u7528\u5df2\u4e0d\u5b58\u5728");
        }
        if (!SDK.getAppAPI().isActive(profile.getAppContext().getId())) {
            return AlertWindow.getWarningMessagePage((String)"\u8b66\u544a", (String)"\u8981\u6267\u884c\u7684\u5e94\u7528\u6682\u505c\u4f7f\u7528");
        }
        Constructor cons = null;
        try {
            Class[] parameterTypes = new Class[]{UserContext.class};
            cons = ClassReflect.getConstructor((String)profile.getMainClass(), (Class[])parameterTypes, (AppContext)profile.getAppContext());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            SDK.getAppAPI().err(profile.getAppContext(), profile.getMainClass() + "--" + e.toString());
            return AlertWindow.getWarningMessagePage((String)"\u8b66\u544a", (String)e.toString());
        }
        try {
            Class<?> mainClass = Class.forName(profile.getMainClass());
            Object obj = cons.newInstance(context);
            Method execute = mainClass.getMethod("getHome", String.class);
            return (String)execute.invoke(obj, teamId);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            SDK.getAppAPI().err(profile.getAppContext(), profile.getMainClass() + "--" + e.toString());
            return AlertWindow.getWarningMessagePage((String)"\u8b66\u544a", (String)e.toString());
        }
    }

    public static void signalTeamDeleted(String teamId) {
        for (TeamAppProfile p : _list) {
            if (UtilString.isEmpty((String)p.getDeletedClass()) || !SDK.getAppAPI().isActive(p.getAppContext().getId())) continue;
            SignalTeamDeleted signal = new SignalTeamDeleted(p, teamId);
            Thread signalThread = new Thread(signal);
            signalThread.setName("com.actionsoft.apps.network Thread(Signal Team Deleted)-" + p.getTitle());
            signalThread.start();
        }
    }
}

