/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import dn.recordFormChanges;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Controller
public class contractApproveController {
    private static final Logger contractLogger;

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_service")
    public ResponseObject approveService(UserContext uc, String approveDate, String approveIds) throws SQLException {
        if (StringUtils.isBlank((CharSequence)approveDate) || StringUtils.isBlank((CharSequence)approveIds)) {
            return ResponseObject.newErrResponse((String)"\u53c2\u6570\u9519\u8bef");
        }
        contractService.getInstance().postRecurringServices(uc, approveDate, approveIds);
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_milestone")
    public ResponseObject approveMilestone(UserContext uc, String approveDate, String approveIds) throws SQLException {
        if (StringUtils.isBlank((CharSequence)approveDate) || StringUtils.isBlank((CharSequence)approveIds)) {
            return ResponseObject.newErrResponse((String)"\u53c2\u6570\u9519\u8bef");
        }
        contractService.getInstance().postMilestone(uc, approveDate, approveIds);
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_updateExtendedPrice")
    public ResponseObject updateExtendedPrice(UserContext uc, Double periodPrice, String id, int type) throws SQLException {
        if (type != 86 && type == 87) {
            BO ccBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", id);
            if (ccBO != null) {
                ccBO.set("ADJUST_SETUP_FEE", (Object)periodPrice);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", ccBO);
            } else {
                BO ccsaBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", id);
                if (ccsaBO != null) {
                    ccsaBO.set("ADJUST_PRORATED_PRICE_CHANGE", (Object)periodPrice);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", ccsaBO);
                } else {
                    BO ccspBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", id);
                    if (ccspBO != null) {
                        ccspBO.set("PERIOD_ADJUSTED_PRICE", (Object)periodPrice);
                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", ccspBO);
                    }
                }
            }
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_restoreInitialPrice")
    public ResponseObject restoreInitialPrice(UserContext uc, String ids, int type) throws SQLException {
        if (type != 86 && type == 87) {
            for (String id : ids.split(",")) {
                BO ccBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", id);
                if (ccBO != null) {
                    ccBO.set("ADJUST_SETUP_FEE", ccBO.get("SETUP_FEE"));
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", ccBO);
                    continue;
                }
                BO ccsaBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", id);
                if (ccsaBO != null) {
                    ccsaBO.set("ADJUST_PRORATED_PRICE_CHANGE", ccsaBO.get("PRORATED_PRICE_CHANGE"));
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", ccsaBO);
                    continue;
                }
                BO ccspBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", id);
                if (ccspBO == null) continue;
                ccspBO.set("PERIOD_ADJUSTED_PRICE", ccspBO.get("PERIOD_PRICE"));
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", ccspBO);
            }
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_cost")
    public ResponseObject cost(UserContext uc, String approveDate, String approveIds) throws SQLException {
        boolean result = contractService.getInstance().postCost(uc, approveDate, approveIds);
        return result ? ResponseObject.newOkResponse() : ResponseObject.newErrResponse((String)"\u5ba1\u6279\u5931\u8d25");
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_recurring_services")
    public ResponseObject revokeRecurringServices(UserContext uc, String ids) throws SQLException {
        String result = contractService.getInstance().revokeRecurringServices(uc, ids);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseObject.newErrResponse((String)result);
        }
        contractLogger.info("\u64a4\u9500\u5b9a\u671f\u670d\u52a1\u6210\u529f");
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_milestones")
    public ResponseObject revokeMilestones(UserContext uc, String ids) throws SQLException {
        String result = contractService.getInstance().revokeMilestones(uc, ids);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseObject.newErrResponse((String)result);
        }
        contractLogger.info("\u64a4\u9500\u91cc\u7a0b\u7891\u6210\u529f");
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_cost")
    public ResponseObject revokeCost(UserContext uc, String ids) throws SQLException {
        String result = contractService.getInstance().revokeCost(uc, ids);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResponseObject.newErrResponse((String)result);
        }
        contractLogger.info("\u64a4\u9500\u5408\u540c\u6210\u672c\u6210\u529f");
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.modify_taxRate")
    public ResponseObject modifyTaxRate(UserContext uc, String id) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
        String account_id = bo.getString("ACCOUNT_ID");
        String extended_price = bo.getString("EXTENDED_PRICE");
        String tax_category_id = bo.getString("TAX_CATEGORY_ID");
        String effective_tax_rate = bo.getString("EFFECTIVE_TAX_RATE");
        String tax_dollars = bo.getString("TAX_DOLLARS");
        List effectiveTaxRateList = DBSql.getMaps((String)"select tax_cate_id as taxCateId,total_effective_tax_rate as effectiveTaxRate from bo_eu_dnd_tax_region_cate where tax_region_id IN (select tax_region_id from bo_eu_dncrm_account where id=?)", (Object[])new Object[]{account_id});
        List taxCateList = DBSql.getMaps((String)"SELECT oid,NAME FROM bo_eu_dnd_general WHERE general_table_id=44 AND CLOSED=0 AND ORGID=? AND oid in(select tax_cate_id from bo_eu_dnd_tax_region_cate where tax_region_id in (select tax_region_id from bo_eu_dncrm_account where id=?))", (Object[])new Object[]{uc.getCompanyModel().getId(), account_id});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taxCateList", taxCateList);
        map.put("effectiveTaxRateList", effectiveTaxRateList);
        map.put("taxCateId", tax_category_id);
        map.put("effectiveTaxRate", effective_tax_rate);
        map.put("taxDollars", tax_dollars);
        map.put("extendedPrice", extended_price);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(map);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.modify_taxRate_save")
    public ResponseObject modifyTaxRateSave(UserContext uc, String id, String taxCateId, String effectiveTaxRate, String taxDollars) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
        bo.set("TAX_CATEGORY_ID", (Object)taxCateId);
        bo.set("tax_category_name", (Object)DBSql.getString((String)"SELECT NAME FROM bo_eu_dnd_general WHERE general_table_id=44 AND oid=?", (Object[])new Object[]{taxCateId}));
        bo.set("EFFECTIVE_TAX_RATE", (Object)effectiveTaxRate);
        bo.set("TAX_DOLLARS", (Object)taxDollars);
        SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo);
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_labor")
    public ResponseObject laborApprove(UserContext uc, String approveDate, String approveIds) {
        String[] IdArr = approveIds.split(",");
        String sql = "SELECT * FROM VIEW_EU_DNV_PENDING_LABOR WHERE ID IN(";
        for (int i = 0; IdArr.length > i; ++i) {
            sql = sql + "?,";
        }
        sql = sql.substring(0, sql.length() - 1) + ")";
        List list = DBSql.getMaps((String)sql, (Object[])Arrays.stream(IdArr).toArray());
        String ORGID = uc.getCompanyModel().getId();
        LocalDate thisDate = contractService.getLocalDate(approveDate);
        for (RowMap thisWorkEntry : list) {
            RowMap thisTax;
            RowMap costCode;
            for (String key : thisWorkEntry.keySet()) {
                thisWorkEntry.put(key.toUpperCase(), thisWorkEntry.get((Object)key) == null ? "" : thisWorkEntry.get((Object)key));
            }
            BO oldEntry = SDK.getBOAPI().get("BO_EU_DNSDK_WORK_ENTRY", thisWorkEntry.getString("ID"));
            String COST_CODE_ID = oldEntry.getString("COST_CODE_ID");
            System.out.println("COST_CODE_ID:" + COST_CODE_ID);
            RowMap thisTaxCate = null;
            if (StringUtils.isNotBlank((CharSequence)COST_CODE_ID) && (costCode = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_COST_CODE WHERE OID=? AND ORGID=?", (Object[])new Object[]{COST_CODE_ID, ORGID})) != null && StringUtils.isNotBlank((CharSequence)costCode.getString("TAX_CATEGORY_ID"))) {
                thisTaxCate = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_GENERAL WHERE OID=?  AND ORGID=?", (Object[])new Object[]{costCode.getString("TAX_CATEGORY_ID"), ORGID});
            }
            System.out.println("TAX_CATEGORY_ID:" + thisTaxCate.getString("OID"));
            Double tax_rate = 0.0;
            RowMap thisTaxRegion = null;
            RowMap thisAccount = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCRM_ACCOUNT WHERE ID=?", (Object[])new Object[]{thisWorkEntry.getString("ACCOUNT_ID")});
            if (thisAccount != null && StringUtils.isNotBlank((CharSequence)thisAccount.getString("TAX_REGION_ID"))) {
                thisTaxRegion = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_GENERAL WHERE OID=? AND ORGID=?", (Object[])new Object[]{thisAccount.getString("TAX_REGION_ID"), ORGID});
            }
            System.out.println("TAX_REGION_ID:" + thisTaxRegion.getString("OID"));
            if (thisTaxCate != null && thisTaxRegion != null && (thisTax = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID=? AND TAX_CATEGORY_ID=? AND ORGID=?", (Object[])new Object[]{thisTaxRegion.getString("OID"), thisTaxCate.getString("OID"), ORGID})) != null) {
                tax_rate = thisTax.getDouble("TOTAL_EFFECTIVE_TAX_RATE");
            }
            Double block_hour_multiplier = 0.0;
            RowMap thisConRole = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_RATE WHERE CONTRACT_ID=? AND ROLE_ID=?", (Object[])new Object[]{thisWorkEntry.getString("CONTRACT_ID"), thisWorkEntry.getString("ROLE_ID")});
            if (thisConRole != null) {
                block_hour_multiplier = thisConRole.getDouble("BLOCK_HOUR_MULTIPLIER");
            } else {
                RowMap thisRole = DBSql.getMap((String)"SELECT * FROM BO_EU_DNSYS_ROLE WHERE ID=?", (Object[])new Object[]{thisWorkEntry.getString("ROLE_ID")});
                if (thisRole != null) {
                    block_hour_multiplier = thisRole.getDouble("HOURLY_FACTOR");
                }
            }
            BO thisDed = new BO();
            thisDed.set("TYPE_ID", (Object)"1318");
            thisDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
            thisDed.set("POSTED_DATE", (Object)thisDate);
            thisDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
            thisDed.set("EXTENDED_PRICE", (Object)thisWorkEntry.getDouble("DOLLARS"));
            thisDed.set("ACCOUNT_ID", (Object)thisWorkEntry.getString("ACCOUNT_ID"));
            thisDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
            thisDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
            thisDed.set("BILL_ACCOUNT_ID", (Object)thisWorkEntry.getString("BILL_ACCOUNT_ID"));
            thisDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
            thisDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
            thisDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
            thisDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
            thisDed.set("QUANTITY", thisWorkEntry.get((Object)"QUANTITY"));
            thisDed.set("RATE", thisWorkEntry.get((Object)"RATE"));
            thisDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
            thisDed.set("EXTENDED_COST", thisWorkEntry.get((Object)"COST"));
            if (thisTaxCate != null) {
                thisDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("OID"));
            }
            if ((thisAccount == null || !thisAccount.getString("IS_TAX_EXEMPT").equals("1")) && tax_rate > 0.0) {
                thisDed.set("TAX_DOLLARS", (Object)(thisWorkEntry.getDouble("DOLLARS") * (1.0 - 1.0 / (1.0 + tax_rate))));
            }
            if (StringUtils.isBlank((CharSequence)thisDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisDed.getString("ACCOUNT_ID"))) {
                thisDed.set("BILL_ACCOUNT_ID", thisDed.get("ACCOUNT_ID"));
            }
            recordFormChanges.record((UserContext)uc, (BO)thisDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
            SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisDed, uc);
            oldEntry.set("APPROVE_AND_POST_DATE", (Object)thisDate);
            oldEntry.set("APPROVE_AND_POST_USER_ID", (Object)uc.getUID());
            recordFormChanges.record((UserContext)uc, (BO)oldEntry, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
            SDK.getBOAPI().update("BO_EU_DNSDK_WORK_ENTRY", oldEntry);
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_labor2")
    public ResponseObject laborApprove2(UserContext uc, String approveDate, String approveIds) {
        String[] IdArr = approveIds.split(",");
        String sql = "SELECT * FROM VIEW_EU_DNV_PENDING_LABOR WHERE ID IN(";
        for (int i = 0; IdArr.length > i; ++i) {
            sql = sql + "?,";
        }
        sql = sql.substring(0, sql.length() - 1) + ")";
        List list = DBSql.getMaps((String)sql, (Object[])Arrays.stream(IdArr).toArray());
        String ORGID = uc.getCompanyModel().getId();
        for (RowMap rowMap : list) {
            RowMap thisTax;
            RowMap thatAccount;
            RowMap costCode;
            String COST_CODE_ID = this.getString(rowMap, "COST_CODE_ID");
            RowMap thisTaxCate = null;
            if (StringUtils.isNotBlank((CharSequence)COST_CODE_ID) && (costCode = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_COST_CODE WHERE OID=? AND ORGID=?", (Object[])new Object[]{COST_CODE_ID, ORGID})) != null && StringUtils.isNotBlank((CharSequence)costCode.getString("TAX_CATEGORY_ID"))) {
                thisTaxCate = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_GENERAL WHERE OID=?  AND ORGID=?", (Object[])new Object[]{costCode.getString("TAX_CATEGORY_ID"), ORGID});
            }
            RowMap thisContract = null;
            RowMap thisAccount = null;
            String CONTRRACT_ID = this.getString(rowMap, "CONTRACT_ID");
            if (StringUtils.isNotBlank((CharSequence)CONTRRACT_ID)) {
                thisContract = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT WHERE ID=?", (Object[])new Object[]{CONTRRACT_ID});
                RowMap thatAccount2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCRM_ACCOUNT WHERE ID IN (SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID=?)", (Object[])new Object[]{CONTRRACT_ID});
                if (thatAccount2 != null) {
                    thisAccount = thatAccount2;
                }
            }
            RowMap thisTaxRegion = null;
            Double tax_rate = 0.0;
            String TASK_ID = rowMap.getString("TASK_ID");
            if (StringUtils.isNotBlank((CharSequence)TASK_ID) && (thatAccount = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCRM_ACCOUNT WHERE ID IN (SELECT ACCOUNT_ID FROM BO_EU_DNSDK_TASK WHERE ID=?)", (Object[])new Object[]{TASK_ID})) != null) {
                thisAccount = thatAccount;
            }
            String thisContractId = thisContract == null ? "null" : thisContract.getString("ID");
            String ROLE_ID = rowMap.getString("ROLE_ID");
            Double laborRate = 0.0;
            try {
                laborRate = DBSql.getDouble((String)("SELECT f_get_labor_rate(" + thisContractId + "," + COST_CODE_ID + "," + ROLE_ID + "," + ORGID + ") as laborRate"), (String)"laborRate");
            }
            catch (Exception e) {
                System.out.println("\u83b7\u53d6\u8d39\u7387\u5f02\u5e38" + e.getMessage());
            }
            if (thisAccount != null && StringUtils.isNotBlank((CharSequence)thisAccount.getString("TAX_REGION_ID"))) {
                thisTaxRegion = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_GENERAL WHERE OID=? AND ORGID=?", (Object[])new Object[]{thisAccount.getString("TAX_REGION_ID"), ORGID});
            }
            if (thisTaxCate != null && thisTaxRegion != null && (thisTax = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID=? AND TAX_CATEGORY_ID=? AND ORGID=?", (Object[])new Object[]{thisTaxRegion.getString("OID"), thisTaxCate.getString("OID"), ORGID})) != null) {
                tax_rate = thisTax.getDouble("TOTAL_EFFECTIVE_TAX_RATE");
            }
            LocalDate thisDate = contractService.getLocalDate(approveDate);
            Double block_hour_multiplier = 0.0;
            if (thisContract != null && StringUtils.isNotBlank((CharSequence)ROLE_ID)) {
                RowMap thisConRole = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_RATE WHERE CONTRACT_ID=? AND ROLE_ID=?", (Object[])new Object[]{thisContract.getString("ID"), ROLE_ID});
                if (thisConRole != null) {
                    block_hour_multiplier = thisConRole.getDouble("BLOCK_HOUR_MULTIPLIER");
                } else {
                    RowMap thisRole = DBSql.getMap((String)"SELECT * FROM BO_EU_DNSYS_ROLE WHERE ID=?", (Object[])new Object[]{ROLE_ID});
                    if (thisRole != null) {
                        block_hour_multiplier = thisRole.getDouble("HOURLY_FACTOR");
                    }
                }
            }
            HashMap<String, Double> block = new HashMap<String, Double>();
            HashMap<String, Double> blockRate = new HashMap<String, Double>();
            RowMap thisWorkEntry = DBSql.getMap((String)"select * from BO_EU_DNSDK_WORK_ENTRY where ID=?", (Object[])new Object[]{this.getString(rowMap, "ID")});
            LocalDate thisEntryDate = contractService.getLocalDate(this.getString(thisWorkEntry, "START_TIME"));
            LocalDate thisEntryEndDate = StringUtils.isBlank((CharSequence)this.getString(thisWorkEntry, "START_TIME")) ? thisEntryDate : contractService.getLocalDate(this.getString(thisWorkEntry, "END_TIME"));
            LocalDate thisContractStartDate = thisContract == null ? null : thisContract.getDate("START_DATE").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate thisContractEndDate = thisContract == null ? null : thisContract.getDate("END_DATE").toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            Double totalHours = StringUtils.isBlank((CharSequence)thisWorkEntry.getString("HOURS_BILLED_DEDUCTION")) ? thisWorkEntry.getDouble("HOURS_BILLED") : thisWorkEntry.getDouble("HOURS_BILLED_DEDUCTION");
            if (thisContract != null && thisEntryDate != null && thisContractStartDate.compareTo(thisEntryDate) <= 0 && thisContractEndDate.compareTo(thisEntryEndDate) >= 0) {
                String endDate = thisEntryDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                Double totalMoney = StringUtils.isBlank((CharSequence)thisWorkEntry.getString("HOURS_BILLED_DEDUCTION")) ? thisWorkEntry.getDouble("HOURS_BILLED") : thisWorkEntry.getDouble("HOURS_BILLED_DEDUCTION");
                totalMoney = totalMoney * (StringUtils.isBlank((CharSequence)thisWorkEntry.getString("HOURS_RATE_DEDUCTION")) ? laborRate.doubleValue() : thisWorkEntry.getDouble("HOURS_RATE_DEDUCTION"));
                if (laborRate == null || laborRate <= 0.0) {
                    BO thisBlockDed = new BO();
                    thisBlockDed.set("TYPE_ID", (Object)"1318");
                    thisBlockDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                    thisBlockDed.set("POSTED_DATE", (Object)thisDate);
                    thisBlockDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                    thisBlockDed.set("ACCOUNT_ID", (Object)thisAccount.getString("ID"));
                    thisBlockDed.set("QUANTITY", (Object)totalHours);
                    thisBlockDed.set("BILL_CREATE_USER_ID", (Object)thisWorkEntry.getString("CREATEUSER"));
                    thisBlockDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                    thisBlockDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                    thisBlockDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                    thisBlockDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                    thisBlockDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                    thisBlockDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                    thisBlockDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                    if (thisTaxCate != null) {
                        thisBlockDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("OID"));
                    }
                    thisBlockDed.set("EXTENDED_PRICE", (Object)0);
                    thisBlockDed.set("BILL_ACCOUNT_ID", thisWorkEntry.get((Object)"BILL_ACCOUNT_ID"));
                    if (StringUtils.isBlank((CharSequence)thisBlockDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisBlockDed.getString("ACCOUNT_ID"))) {
                        thisBlockDed.set("BILL_ACCOUNT_ID", thisBlockDed.get("ACCOUNT_ID"));
                    }
                    recordFormChanges.record((UserContext)uc, (BO)thisBlockDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                    SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisBlockDed, uc);
                } else if (thisContract != null && thisContract.getString("TYPE_ID").equals("1203")) {
                    Double extended_price = DBSql.getDouble((String)("SELECT sum(round(b.rate/" + laborRate + " - ifnull((SELECT sum(extended_price)FROM bo_eu_dncrm_account_deduction WHERE contract_block_id = b.id ),0),2)) AS RATE FROM bo_eu_dnctt_contract_block b WHERE b.contract_id='" + thisContract.getString("ID") + "' and b.status_id=1 and b.start_date <='" + thisEntryDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "' and b.end_date >='" + endDate + "'"), (String)"RATE");
                    extended_price = extended_price * laborRate;
                    List block_hours = DBSql.getMaps((String)("SELECT b.ID,(round(b.rate/" + laborRate + " - ifnull((SELECT sum(extended_price)FROM bo_eu_dncrm_account_deduction WHERE contract_block_id = b.id ),0),2)) AS RATE FROM bo_eu_dnctt_contract_block b WHERE b.contract_id='" + thisContract.getString("ID") + "' and b.status_id=1 and b.start_date <='" + thisEntryDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "' and b.end_date >='" + endDate + "'"), (Object[])new Object[0]);
                    for (Object block_hour : block_hours) {
                        if (block_hour.get((Object)"RATE") != null && block_hour.getDouble("RATE") > 0.0) {
                            block.put(block_hour.getString("ID"), block_hour.getDouble("RATE"));
                        }
                        blockRate.put(block_hour.getString("ID"), block_hour.getDouble("RATE"));
                    }
                    if (totalMoney == null || totalMoney <= extended_price) {
                        if (totalMoney != null) {
                            Object block_hour;
                            Double extend = 0.0;
                            block_hour = block.keySet().iterator();
                            while (block_hour.hasNext()) {
                                BO thisBlockDed;
                                String key = (String)block_hour.next();
                                if ((extend = Double.valueOf(extend + (Double)block.get(key))) <= totalMoney) {
                                    thisBlockDed = new BO();
                                    thisBlockDed.set("TYPE_ID", (Object)"1318");
                                    thisBlockDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                                    thisBlockDed.set("POSTED_DATE", (Object)thisDate);
                                    thisBlockDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                                    thisBlockDed.set("EXTENDED_PRICE", block.get(key));
                                    thisBlockDed.set("ACCOUNT_ID", (Object)thisWorkEntry.getString("ACCOUNT_ID"));
                                    thisBlockDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                                    thisBlockDed.set("BILL_CREATE_USER_ID", (Object)thisWorkEntry.getString("CREATEUSER"));
                                    thisBlockDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                                    thisBlockDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                                    thisBlockDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                                    thisBlockDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                                    thisBlockDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                                    thisBlockDed.set("QUANTITY", (Object)totalHours);
                                    thisBlockDed.set("RATE", blockRate.get(key));
                                    thisBlockDed.set("CONTRACT_BLOCK_ID", (Object)key);
                                    thisBlockDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
                                    thisBlockDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                                    if (thisTaxCate != null) {
                                        thisBlockDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("ID"));
                                    }
                                    if (!thisAccount.getString("IS_TAX_EXEMPT").equals("1")) {
                                        thisBlockDed.set("TAX_DOLLARS", (Object)(thisWorkEntry.getDouble("HOURS_BILLED") * laborRate * (1.0 - 1.0 / (1.0 + tax_rate))));
                                    }
                                    if (thisWorkEntry.getString("IS_BILLABLE").equals("0")) {
                                        thisBlockDed.set("EXTENDED_PRICE", (Object)0);
                                    }
                                    if (StringUtils.isBlank((CharSequence)thisBlockDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisBlockDed.getString("ACCOUNT_ID"))) {
                                        thisBlockDed.set("BILL_ACCOUNT_ID", thisBlockDed.get("ACCOUNT_ID"));
                                    }
                                    recordFormChanges.record((UserContext)uc, (BO)thisBlockDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                                    SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisBlockDed, uc);
                                    BO thisBlock = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_BLOCK", key);
                                    if (thisBlock != null) {
                                        thisBlock.set("STATUS_ID", (Object)0);
                                        recordFormChanges.record((UserContext)uc, (BO)thisBlock, (String)"\u4fee\u6539\u9884\u4ed8\u8d39\u4fe1\u606f");
                                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_BLOCK", thisBlock);
                                    }
                                    if (extend != totalMoney) continue;
                                } else {
                                    thisBlockDed = new BO();
                                    thisBlockDed.set("TYPE_ID", (Object)"1318");
                                    thisBlockDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                                    thisBlockDed.set("POSTED_DATE", (Object)thisDate);
                                    thisBlockDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                                    thisBlockDed.set("EXTENDED_PRICE", block.get(key));
                                    thisBlockDed.set("ACCOUNT_ID", (Object)thisWorkEntry.getString("ACCOUNT_ID"));
                                    thisBlockDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                                    thisBlockDed.set("BILL_CREATE_USER_ID", (Object)thisWorkEntry.getString("CREATEUSER"));
                                    thisBlockDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                                    thisBlockDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                                    thisBlockDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                                    thisBlockDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                                    thisBlockDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                                    thisBlockDed.set("QUANTITY", (Object)totalHours);
                                    thisBlockDed.set("RATE", blockRate.get(key));
                                    thisBlockDed.set("CONTRACT_BLOCK_ID", (Object)key);
                                    thisBlockDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
                                    thisBlockDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                                    if (thisTaxCate != null) {
                                        thisBlockDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("ID"));
                                    }
                                    thisBlockDed.set("extended_price", (Object)((Double)block.get(key) - (extend - totalMoney)));
                                    if (thisWorkEntry.getString("IS_BILLABLE").equals("0")) {
                                        thisBlockDed.set("EXTENDED_PRICE", (Object)0);
                                    }
                                    if (StringUtils.isBlank((CharSequence)thisBlockDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisBlockDed.getString("ACCOUNT_ID"))) {
                                        thisBlockDed.set("BILL_ACCOUNT_ID", thisBlockDed.get("ACCOUNT_ID"));
                                    }
                                    recordFormChanges.record((UserContext)uc, (BO)thisBlockDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                                    SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisBlockDed, uc);
                                }
                                break;
                            }
                        } else {
                            BO thisBlockDed = new BO();
                            thisBlockDed.set("TYPE_ID", (Object)"1318");
                            thisBlockDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                            thisBlockDed.set("POSTED_DATE", (Object)thisDate);
                            thisBlockDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                            thisBlockDed.set("ACCOUNT_ID", (Object)thisWorkEntry.getString("ACCOUNT_ID"));
                            thisBlockDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                            thisBlockDed.set("BILL_CREATE_USER_ID", (Object)thisWorkEntry.getString("CREATEUSER"));
                            thisBlockDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                            thisBlockDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                            thisBlockDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                            thisBlockDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                            thisBlockDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                            thisBlockDed.set("QUANTITY", (Object)totalHours);
                            thisBlockDed.set("RATE", thisWorkEntry.get((Object)"HOURS_RATE_DEDUCTION") != null ? thisWorkEntry.get((Object)"HOURS_RATE_DEDUCTION") : laborRate);
                            thisBlockDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
                            thisBlockDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                            if (thisTaxCate != null) {
                                thisBlockDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("ID"));
                            }
                            if (thisWorkEntry.getString("IS_BILLABLE").equals("0")) {
                                thisBlockDed.set("EXTENDED_PRICE", (Object)0);
                            }
                            if (StringUtils.isBlank((CharSequence)thisBlockDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisBlockDed.getString("ACCOUNT_ID"))) {
                                thisBlockDed.set("BILL_ACCOUNT_ID", thisBlockDed.get("ACCOUNT_ID"));
                            }
                            recordFormChanges.record((UserContext)uc, (BO)thisBlockDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                            SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisBlockDed, uc);
                        }
                    } else {
                        RowMap ccnr = DBSql.getMap((String)"select * from BO_EU_DNCTT_CONTRACT_NOTIFY_RULE where contract_id=?", (Object[])new Object[]{thisContractId});
                        if (ccnr != null && ccnr.get((Object)"RATE") != null && ccnr.getDouble("RATE") > 0.0) {
                            Double extend = 0.0;
                            for (String key : block.keySet()) {
                                extend = extend + (Double)block.get(key);
                                BO thisBlockDed = new BO();
                                thisBlockDed.set("TYPE_ID", (Object)"1318");
                                thisBlockDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                                thisBlockDed.set("POSTED_DATE", (Object)thisDate);
                                thisBlockDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                                thisBlockDed.set("EXTENDED_PRICE", block.get(key));
                                thisBlockDed.set("ACCOUNT_ID", (Object)thisWorkEntry.getString("ACCOUNT_ID"));
                                thisBlockDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                                thisBlockDed.set("BILL_CREATE_USER_ID", (Object)thisWorkEntry.getString("CREATEUSER"));
                                thisBlockDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                                thisBlockDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                                thisBlockDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                                thisBlockDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                                thisBlockDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                                thisBlockDed.set("QUANTITY", (Object)totalHours);
                                thisBlockDed.set("RATE", blockRate.get(key));
                                thisBlockDed.set("CONTRACT_BLOCK_ID", (Object)key);
                                thisBlockDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
                                thisBlockDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                                if (thisTaxCate != null) {
                                    thisBlockDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("ID"));
                                }
                                if (thisWorkEntry.getString("IS_BILLABLE").equals("0")) {
                                    thisBlockDed.set("EXTENDED_PRICE", (Object)0);
                                }
                                if (!thisAccount.getString("IS_TAX_EXEMPT").equals("1")) {
                                    thisBlockDed.set("TAX_DOLLARS", (Object)(thisWorkEntry.getDouble("HOURS_BILLED") * laborRate * (1.0 - 1.0 / (1.0 + tax_rate))));
                                }
                                if (StringUtils.isBlank((CharSequence)thisBlockDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisBlockDed.getString("ACCOUNT_ID"))) {
                                    thisBlockDed.set("BILL_ACCOUNT_ID", thisBlockDed.get("ACCOUNT_ID"));
                                }
                                recordFormChanges.record((UserContext)uc, (BO)thisBlockDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisBlockDed, uc);
                                BO thisBlock = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_BLOCK", key);
                                if (thisBlock == null) continue;
                                thisBlock.set("STATUS_ID", (Object)0);
                                recordFormChanges.record((UserContext)uc, (BO)thisBlock, (String)"\u4fee\u6539\u5408\u540c\u6210\u672c\u9884\u4ed8\u65f6\u95f4\u6216\u8d39\u7528");
                                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_BLOCK", thisBlock);
                            }
                            if (extend - totalMoney <= 0.0) {
                                System.out.println("\u5408\u540c\u91d1\u989d\u4e0d\u8db3");
                                System.out.println("\u540e\u9762\u600e\u4e48\u5904\u7406\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                            }
                        } else {
                            BO thisDed = new BO();
                            thisDed.set("TYPE_ID", (Object)"1318");
                            thisDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                            thisDed.set("POSTED_DATE", (Object)thisDate);
                            thisDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                            thisDed.set("EXTENDED_PRICE", (Object)(thisWorkEntry.getDouble("HOURS_BILLED") * laborRate * block_hour_multiplier));
                            thisDed.set("ACCOUNT_ID", (Object)thisAccount.getString("ID"));
                            thisDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                            thisDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                            thisDed.set("BILL_ACCOUNT_ID", (Object)thisWorkEntry.getString("BILL_ACCOUNT_ID"));
                            thisDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                            thisDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                            thisDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                            thisDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                            thisDed.set("QUANTITY", (Object)totalHours);
                            thisDed.set("RATE", thisWorkEntry.get((Object)"HOURS_RATE_DEDUCTION") != null ? thisWorkEntry.get((Object)"HOURS_RATE_DEDUCTION") : laborRate);
                            thisDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
                            thisDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                            if (thisTaxCate != null) {
                                thisDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("ID"));
                            }
                            if (thisWorkEntry.getString("IS_BILLABLE").equals("0")) {
                                thisDed.set("EXTENDED_PRICE", (Object)0);
                            }
                            if (!thisAccount.getString("IS_TAX_EXEMPT").equals("1")) {
                                thisDed.set("TAX_DOLLARS", (Object)(thisWorkEntry.getDouble("HOURS_BILLED") * laborRate * (1.0 - 1.0 / (1.0 + tax_rate))));
                            }
                            if (StringUtils.isBlank((CharSequence)thisDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisDed.getString("ACCOUNT_ID"))) {
                                thisDed.set("BILL_ACCOUNT_ID", thisDed.get("ACCOUNT_ID"));
                            }
                            recordFormChanges.record((UserContext)uc, (BO)thisDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                            SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisDed, uc);
                        }
                    }
                }
            }
            if (thisContract == null || !thisContract.getString("type_id").equals("1203") && !thisContract.getString("TYPE_ID").equals("1202") || thisContractStartDate.compareTo(thisEntryDate) > 0 || thisContractEndDate.compareTo(thisEntryEndDate) < 0) {
                BO thisDed = new BO();
                thisDed.set("TYPE_ID", (Object)"1318");
                thisDed.set("OBJECT_ID", (Object)thisWorkEntry.getString("ID"));
                thisDed.set("POSTED_DATE", (Object)thisDate);
                thisDed.set("TASK_ID", (Object)thisWorkEntry.getString("TASK_ID"));
                thisDed.set("EXTENDED_PRICE", (Object)(thisWorkEntry.getDouble("HOURS_BILLED") * laborRate * block_hour_multiplier));
                thisDed.set("ACCOUNT_ID", thisAccount == null ? null : thisAccount.getString("ID"));
                thisDed.set("CONTRACT_ID", (Object)thisWorkEntry.getString("CONTRACT_ID"));
                thisDed.set("PURCHASE_ORDER_NO", (Object)thisWorkEntry.getString("PURCHASE_ORDER_NO"));
                thisDed.set("BILL_ACCOUNT_ID", (Object)thisWorkEntry.getString("BILL_ACCOUNT_ID"));
                thisDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
                thisDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
                thisDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                thisDed.set("ROLE_ID", (Object)thisWorkEntry.getString("ROLE_ID"));
                thisDed.set("QUANTITY", (Object)totalHours);
                thisDed.set("RATE", thisWorkEntry.get((Object)"HOURS_RATE_DEDUCTION") != null ? thisWorkEntry.get((Object)"HOURS_RATE_DEDUCTION") : laborRate);
                thisDed.set("BLOCK_HOUR_MULTIPLIER", (Object)block_hour_multiplier);
                thisDed.set("EXTENDED_COST", (Object)contractService.GetEntryCost(thisWorkEntry.getString("ID")));
                if (thisTaxCate != null) {
                    thisDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("ID"));
                }
                if (thisWorkEntry.getString("IS_BILLABLE").equals("0")) {
                    thisDed.set("EXTENDED_PRICE", (Object)0);
                }
                if (!thisAccount.getString("IS_TAX_EXEMPT").equals("1")) {
                    thisDed.set("TAX_DOLLARS", (Object)(thisWorkEntry.getDouble("HOURS_BILLED") * laborRate * (1.0 - 1.0 / (1.0 + tax_rate))));
                }
                if (StringUtils.isBlank((CharSequence)thisDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisDed.getString("ACCOUNT_ID"))) {
                    thisDed.set("BILL_ACCOUNT_ID", thisDed.get("ACCOUNT_ID"));
                }
                recordFormChanges.record((UserContext)uc, (BO)thisDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisDed, uc);
            }
            BO oldEntry = SDK.getBOAPI().get("BO_EU_DNSDK_WORK_ENTRY", thisWorkEntry.getString("ID"));
            oldEntry.set("APPROVE_AND_POST_DATE", (Object)thisDate);
            oldEntry.set("APPROVE_AND_POST_USER_ID", (Object)uc.getUID());
            recordFormChanges.record((UserContext)uc, (BO)oldEntry, (String)"\u5ba1\u6279\u63d0\u4ea4\u5de5\u65f6");
            SDK.getBOAPI().update("BO_EU_DNSDK_WORK_ENTRY", oldEntry);
        }
        return ResponseObject.newOkResponse();
    }

    private String getString(RowMap rowMap, String key) {
        if (rowMap.containsKey((Object)key)) {
            return rowMap.getString(key);
        }
        if (rowMap.containsKey((Object)key.toUpperCase())) {
            return rowMap.getString(rowMap.getString(key.toUpperCase()));
        }
        if (rowMap.containsKey((Object)key.toLowerCase())) {
            return rowMap.getString(rowMap.getString(key.toLowerCase()));
        }
        key = key.toUpperCase();
        for (String s : rowMap.keySet()) {
            if (!s.toUpperCase().equals(key)) continue;
            return rowMap.getString(s);
        }
        return null;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.approve_expense")
    public ResponseObject expenseApprove(UserContext uc, String approveDate, String approveIds) {
        String[] IdArr = approveIds.split(",");
        String sql = "SELECT * FROM VIEW_EU_DNV_PENDING_EXPENSE WHERE ID IN(";
        for (int i = 0; IdArr.length > i; ++i) {
            sql = sql + "?,";
        }
        sql = sql.substring(0, sql.length() - 1) + ")";
        List list = DBSql.getMaps((String)sql, (Object[])Arrays.stream(IdArr).toArray());
        for (RowMap rowMap : list) {
            String taskRateContractId;
            String projectRateContractId;
            RowMap thisAccount;
            RowMap thisCost;
            String expenseId = this.getString(rowMap, "ID");
            RowMap oldExp = DBSql.getMap((String)"SELECT * FROM BO_EU_DNSDK_EXPENSE WHERE ID=?", (Object[])new Object[]{expenseId});
            RowMap thisTaxCate = null;
            RowMap thisTaxRegion = null;
            Double tax_rate = 0.0;
            String contract_id = null;
            if (StringUtils.isNotBlank((CharSequence)"COST_CODE_ID") && (thisCost = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_COST_CODE WHERE OID=? AND ORGID=?", (Object[])new Object[]{this.getString(rowMap, "COST_CODE_ID"), uc.getCompanyModel().getId()})) != null && StringUtils.isNotBlank((CharSequence)thisCost.getString("TAX_CATEGORY_ID"))) {
                thisTaxCate = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_GENERAL WHERE OID=?  AND ORGID=?", (Object[])new Object[]{thisCost.getString("TAX_CATEGORY_ID"), uc.getCompanyModel().getId()});
            }
            if ((thisAccount = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCRM_ACCOUNT WHERE ID=?", (Object[])new Object[]{this.getString(rowMap, "ACCOUNT_ID")})) != null && StringUtils.isNotBlank((CharSequence)thisAccount.getString("TAX_REGION_ID"))) {
                thisTaxRegion = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_GENERAL WHERE OID=? AND ORGID=?", (Object[])new Object[]{thisAccount.getString("TAX_REGION_ID"), uc.getCompanyModel().getId()});
            }
            if (thisTaxRegion != null && thisTaxCate != null) {
                tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE tax_region_id='" + thisTaxRegion.getString("OID") + "' and tax_cate_id='" + thisTaxCate.getString("OID") + "' and ORGID='" + uc.getCompanyModel().getId() + "'"), (String)"TOTAL_EFFECTIVE_TAX_RATE");
            }
            LocalDate thisDate = contractService.getLocalDate(approveDate);
            if (StringUtils.isNotBlank((CharSequence)oldExp.getString("PROJECT_ID")) && StringUtils.isNotBlank((CharSequence)(projectRateContractId = DBSql.getString((String)"SELECT CONTRACT_ID FROM BO_EU_DNPRO_PROJECT WHERE ID=?", (Object[])new Object[]{oldExp.getString("PROJECT_ID")})))) {
                contract_id = projectRateContractId;
            }
            if (StringUtils.isNotBlank((CharSequence)oldExp.getString("TASK_ID")) && StringUtils.isNotBlank((CharSequence)(taskRateContractId = DBSql.getString((String)"SELECT CONTRACT_ID FROM BO_EU_DNSDK_TASK WHERE ID=?", (Object[])new Object[]{oldExp.getString("TASK_ID")})))) {
                contract_id = taskRateContractId;
            }
            Double extended_price = 0.0;
            if (oldExp.getString("IS_BILLABLE").equals("1")) {
                if (oldExp.get((Object)"AMOUNT_DEDUCTION") != null && oldExp.getDouble("AMOUNT_DEDUCTION") > 0.0) {
                    extended_price = oldExp.getDouble("AMOUNT_DEDUCTION");
                } else if (oldExp.get((Object)"AMOUNT") != null && oldExp.getDouble("AMOUNT") > 0.0) {
                    extended_price = oldExp.getDouble("AMOUNT");
                }
            }
            BO thisDed = new BO();
            thisDed.set("CONTRACT_ID", (Object)contract_id);
            thisDed.set("OBJECT_ID", (Object)oldExp.getString("ID"));
            thisDed.set("TYPE_ID", (Object)"1322");
            thisDed.set("POSTED_DATE", (Object)thisDate);
            thisDed.set("TASK_ID", (Object)oldExp.getString("TASK_ID"));
            thisDed.set("EXTENDED_PRICE", (Object)extended_price);
            thisDed.set("EXTENDED_COST", (Object)extended_price);
            thisDed.set("ACCOUNT_ID", (Object)oldExp.getString("ACCOUNT_ID"));
            thisDed.set("QUANTITY", (Object)1);
            thisDed.set("BILL_CREATE_USER_ID", (Object)oldExp.getString("CREATEUSER"));
            thisDed.set("PURCHASE_ORDER_NO", (Object)oldExp.getString("PURCHASE_ORDER_NO"));
            thisDed.set("TAX_CATEGORY_NAME", thisTaxCate == null ? null : thisTaxCate.getString("NAME"));
            thisDed.set("TAX_REGION_NAME", thisTaxRegion == null ? null : thisTaxRegion.getString("NAME"));
            thisDed.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
            if ((thisAccount == null || !thisAccount.getString("IS_TAX_EXEMPT").equals("1")) && tax_rate > 0.0) {
                thisDed.set("TAX_DOLLARS", (Object)(extended_price * (1.0 - 1.0 / (1.0 + tax_rate))));
            }
            if (thisTaxCate != null) {
                thisDed.set("TAX_CATEGORY_ID", (Object)thisTaxCate.getString("OID"));
            }
            if (StringUtils.isBlank((CharSequence)thisDed.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)thisDed.getString("ACCOUNT_ID"))) {
                thisDed.set("BILL_ACCOUNT_ID", thisDed.get("ACCOUNT_ID"));
            }
            recordFormChanges.record((UserContext)uc, (BO)thisDed, (String)"\u5ba1\u6279\u63d0\u4ea4\u8d39\u7528");
            SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", thisDed, uc);
            BO oldExpense = SDK.getBOAPI().get("BO_EU_DNSDK_EXPENSE", oldExp.getString("ID"));
            oldExpense.set("APPROVE_AND_POST_DATE", (Object)thisDate);
            oldExpense.set("APPROVE_AND_POST_USER_ID", (Object)uc.getUID());
            recordFormChanges.record((UserContext)uc, (BO)oldExpense, (String)"\u5ba1\u6279\u63d0\u4ea4\u8d39\u7528");
            SDK.getBOAPI().update("BO_EU_DNSDK_EXPENSE", oldExpense);
        }
        return ResponseObject.newOkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_labor")
    public ResponseObject revokeLabor(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                bo.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)bo, (String)"\u64a4\u9500\u5de5\u65f6\u5ba1\u6279");
                SDK.getBOAPI().remove("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo.getId(), connUpdate);
                BO oldEntry = SDK.getBOAPI().get("BO_EU_DNSDK_WORK_ENTRY", bo.getString("OBJECT_ID"));
                oldEntry.set("APPROVE_AND_POST_DATE", null);
                oldEntry.set("APPROVE_AND_POST_USER_ID", null);
                recordFormChanges.record((UserContext)uc, (BO)oldEntry, (String)"\u64a4\u9500\u5de5\u65f6\u5ba1\u6279");
                SDK.getBOAPI().update("BO_EU_DNSDK_WORK_ENTRY", oldEntry);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return ResponseObject.newOkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.revoke_expense")
    public ResponseObject revokeExpense(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                bo.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)bo, (String)"\u64a4\u9500\u8d39\u7528\u5ba1\u6279");
                SDK.getBOAPI().remove("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo.getId(), connUpdate);
                BO oldEntry = SDK.getBOAPI().get("BO_EU_DNSDK_EXPENSE", bo.getString("OBJECT_ID"));
                oldEntry.set("APPROVE_AND_POST_DATE", null);
                oldEntry.set("APPROVE_AND_POST_USER_ID", null);
                recordFormChanges.record((UserContext)uc, (BO)oldEntry, (String)"\u64a4\u9500\u8d39\u7528\u5ba1\u6279");
                SDK.getBOAPI().update("BO_EU_DNSDK_EXPENSE", oldEntry);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.insertCommissionPeriods")
    public ResponseObject insertCommissionPeriods(UserContext uc, String bindid, String startDate, String endDate, String amount) {
        if (StringUtils.isBlank((CharSequence)bindid)) {
            return ResponseObject.newErrResponse((String)"bindid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)startDate)) {
            return ResponseObject.newErrResponse((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)endDate)) {
            return ResponseObject.newErrResponse((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)amount)) {
            return ResponseObject.newErrResponse((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.setTime(sdf.parse(startDate));
            int settleDay = cal.get(5);
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(sdf.parse(endDate));
            String insertSql = "INSERT INTO BO_EU_DNCTT_COMMISSION_PERIOD (ID,ORGID, BINDID, PERIOD_BEGIN_DATE, PERIOD_END_DATE, COMMISSION_DOLLARS,PERIOD_ADJUSTED_PRICE) VALUES (UUID(),?, ?, ?, ?, ?,?)";
            int rows = 0;
            Calendar currentCal = Calendar.getInstance();
            currentCal.setTime(sdf.parse(startDate));
            for (int i = 0; i < 12; ++i) {
                Date periodStart = currentCal.getTime();
                currentCal.add(2, 1);
                currentCal.set(5, settleDay);
                currentCal.add(5, -1);
                Date periodEnd = currentCal.getTime();
                if (periodEnd.after(endCal.getTime())) {
                    periodEnd = endCal.getTime();
                }
                rows += DBSql.update((String)insertSql, (Object[])new Object[]{bindid, uc.getCompanyModel().getId(), sdf.format(periodStart), sdf.format(periodEnd), amount, amount});
                currentCal.add(5, 1);
                currentCal.set(5, settleDay);
                if (periodStart.after(endCal.getTime())) break;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("bindid", bindid);
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            result.put("amount", amount);
            result.put("rows", rows);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(result);
            return responseObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse((String)("\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.batchInsertAgentPeriods")
    public ResponseObject batchInsertAgentPeriods(UserContext uc, String bindid, String startDate, String endDate, String amount) {
        if (StringUtils.isBlank((CharSequence)bindid)) {
            return ResponseObject.newErrResponse((String)"bindid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)startDate)) {
            return ResponseObject.newErrResponse((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)endDate)) {
            return ResponseObject.newErrResponse((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)amount)) {
            return ResponseObject.newErrResponse((String)"\u57fa\u7840\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ArrayList agentList = new ArrayList();
            int offset = 0;
            while (true) {
                String querySql = "SELECT AGENT, RATIO FROM BO_EU_DNCTT_COMMISSION_AGENT WHERE bindid = ? LIMIT 1 OFFSET ?";
                RowMap agentMap = DBSql.getMap((String)querySql, (Object[])new Object[]{bindid, offset});
                if (agentMap == null) break;
                String agent = agentMap.getString("AGENT");
                BigDecimal ratio = null;
                Object ratioObj = agentMap.get((Object)"RATIO");
                if (ratioObj != null) {
                    if (ratioObj instanceof BigDecimal) {
                        ratio = (BigDecimal)ratioObj;
                    } else if (ratioObj instanceof Double) {
                        ratio = BigDecimal.valueOf((Double)ratioObj);
                    } else if (ratioObj instanceof Float) {
                        ratio = BigDecimal.valueOf(((Float)ratioObj).doubleValue());
                    } else if (ratioObj instanceof Integer) {
                        ratio = BigDecimal.valueOf(((Integer)ratioObj).longValue());
                    } else {
                        try {
                            ratio = new BigDecimal(ratioObj.toString());
                        }
                        catch (Exception e) {
                            return ResponseObject.newErrResponse((String)("\u4ee3\u7406 " + agent + " \u7684\u6bd4\u4f8b\u683c\u5f0f\u9519\u8bef\uff1a" + ratioObj));
                        }
                    }
                }
                if (ratio == null) {
                    return ResponseObject.newErrResponse((String)("\u4ee3\u7406 " + agent + " \u7684\u6bd4\u4f8b\u4e3a\u7a7a"));
                }
                HashMap<String, Object> agentInfo = new HashMap<String, Object>();
                agentInfo.put("AGENT", agent);
                agentInfo.put("RATIO", ratio);
                agentList.add(agentInfo);
                ++offset;
            }
            if (agentList.isEmpty()) {
                return ResponseObject.newErrResponse((String)"\u672a\u627e\u5230\u4e8c\u7ea7\u4ee3\u7406\u6570\u636e");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.setTime(sdf.parse(startDate));
            int settleDay = cal.get(5);
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(sdf.parse(endDate));
            String insertSql = "INSERT INTO BO_EU_DNCTT_COMMISSION_PERIOD_AGENT (ID, AGENT, BINDID, PERIOD_BEGIN_DATE, PERIOD_END_DATE, COMMISSION_DOLLARS) VALUES (UUID(), ?, ?, ?, ?, ?)";
            int rows = 0;
            BigDecimal baseAmount = new BigDecimal(amount);
            block5: for (Map map : agentList) {
                String agent = (String)map.get("AGENT");
                BigDecimal ratio = (BigDecimal)map.get("RATIO");
                BigDecimal ratioDecimal = ratio.divide(new BigDecimal("100"));
                BigDecimal realCommission = baseAmount.multiply(ratioDecimal);
                Calendar currentCal = Calendar.getInstance();
                currentCal.setTime(sdf.parse(startDate));
                for (int i = 0; i < 12; ++i) {
                    Date periodStart = currentCal.getTime();
                    currentCal.add(2, 1);
                    currentCal.set(5, settleDay);
                    currentCal.add(5, -1);
                    Date periodEnd = currentCal.getTime();
                    if (periodEnd.after(endCal.getTime())) {
                        periodEnd = endCal.getTime();
                    }
                    rows += DBSql.update((String)insertSql, (Object[])new Object[]{agent, bindid, sdf.format(periodStart), sdf.format(periodEnd), realCommission.toPlainString()});
                    currentCal.add(5, 1);
                    currentCal.set(5, settleDay);
                    if (periodStart.after(endCal.getTime())) continue block5;
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("bindid", bindid);
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            result.put("baseAmount", amount);
            result.put("rows", rows);
            result.put("agentCount", agentList.size());
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(result);
            return responseObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse((String)("\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.checkCommissionPeriodExists")
    public ResponseObject checkCommissionPeriodExists(UserContext uc, String bindid) {
        try {
            String checkSql = "SELECT COUNT(1) FROM BO_EU_DNCTT_COMMISSION_PERIOD WHERE BINDID = ?";
            int existCount = DBSql.getInt((String)checkSql, (Object[])new Object[]{bindid});
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put("exists", existCount > 0);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(result);
            return responseObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.checkAgentCommissionPeriodExists")
    public ResponseObject checkAgentCommissionPeriodExists(UserContext uc, String bindid, String startDate, String endDate) {
        try {
            String checkSql = "SELECT COUNT(1) FROM BO_EU_DNCTT_COMMISSION_PERIOD_AGENT WHERE BINDID = ?";
            int existCount = DBSql.getInt((String)checkSql, (Object[])new Object[]{bindid});
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put("exists", existCount > 0);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(result);
            return responseObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    static {
        SDK.getLogAPI();
        contractLogger = LogAPI.getLogger(contractApproveController.class);
    }
}

