/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.util.CollectionUtil;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilImage;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.DCAPI;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTeamAndMember
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTeamAndMember.class);

    @Meta(parameter={"name: 'teamId', required: false, desc: '\u5c0f\u7ec4ID'", "name: 'teamName', required: true, desc: '\u5c0f\u7ec4\u540d'", "name: 'teamType', required: true, desc: '\u5c0f\u7ec4\u7c7b\u578b \uff081-\u516c\u5171,2-\u79c1\u6709,3-\u79d8\u5bc6\uff09'", "name: 'teamLogo', required: false, desc: '\u5c0f\u7ec4Logo'", "name: 'networkId', required: false, desc: '\u5de5\u4f5c\u7f51\u7edcID'", "name: 'teamDesc', required: false, desc: '\u5c0f\u7ec4\u7b80\u4ecb'", "name: 'teamUserIds', required: false, desc: '\u5c0f\u7ec4\u6210\u5458UIDS,\u591a\u4e2a\u65f6\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00'", "name: 'createUser', required: false, desc: '\u521b\u5efa\u4ebauid'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            NetworkTeamModel model;
            UserContext me = null;
            if (params.containsKey("createUser")) {
                String uid = params.get("createUser").toString();
                me = UserContext.fromUID((String)uid);
            }
            if (params.containsKey("sid")) {
                String sid = params.get("sid").toString();
                me = UserContext.fromSessionId((String)sid);
            }
            String teamId = params.get("teamId") == null ? "" : params.get("teamId").toString();
            String teamName = params.get("teamName").toString();
            String teamType = params.get("teamType").toString();
            String teamLogo = params.get("teamLogo") == null ? "" : params.get("teamLogo").toString();
            String networkId = NetworkCache.loadFirstNetworkId();
            if (params.containsKey("networkId")) {
                networkId = params.get("networkId").toString();
            }
            String teamDesc = params.get("teamDesc") == null ? "" : params.get("teamDesc").toString();
            String teamUserIds = params.get("teamUserIds") == null ? "" : params.get("teamUserIds").toString();
            NetworkWeb web = new NetworkWeb(me);
            if (UtilString.isEmpty((String)networkId)) {
                networkId = NetworkCache.loadFirstNetworkId();
            }
            if (UtilString.isEmpty((String)networkId)) {
                return ResponseObject.newErrResponse((String)"\u8bf7\u5148\u521b\u5efa\u5de5\u4f5c\u7f51\u7edc");
            }
            if (UtilString.isEmpty((String)teamId)) {
                teamId = UUIDGener.getUUID();
            }
            if ((model = NetworkTeamCache.getModel(teamId)) == null) {
                model = new NetworkTeamModel();
                model.setId(teamId);
                model.setNetworkId(networkId);
                model.setTeamDesc(teamDesc);
                model.setTeamName(teamName);
                model.setTeamType(teamType);
                model.setTeamLogo("");
                model.setTeamStatus("1");
                model = web.saveTeam(model);
            } else {
                model.setNetworkId(networkId);
                model.setTeamDesc(teamDesc);
                model.setTeamName(teamName);
                model.setTeamType(teamType);
                model = web.updateTeam(model);
            }
            if (!UtilString.isEmpty((String)teamLogo)) {
                DCAPI dcApi = SDK.getDCAPI();
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((byte[])teamLogo.getBytes()));
                DataInputStream dataInputStream = new DataInputStream(bais);
                DCContext dc = new DCContext(me, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!network-logo"), "com.actionsoft.apps.network", "team", model.getId(), "logo_big.jpg");
                dcApi.write((InputStream)dataInputStream, dc);
                UtilImage.zoomCut((String)dc.getFilePath(), (String)(dc.getPath() + "logo.jpg"), (int)120, (int)120);
            }
            if (model != null) {
                String id = model.getId();
                this.saveTeamMember(me, id, teamUserIds);
            }
            ro.put("stream", (Object)NetworkDataUtil.team2JSON(model, me));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }

    public ResponseObject saveTeamMember(UserContext ctx, String teamId, String userIds) {
        ResponseObject result = ResponseObject.newOkResponse();
        StringBuffer errMsg = new StringBuffer();
        try {
            String[] uids;
            List<String> addUids;
            if (UtilString.isEmpty((String)userIds)) {
                result.err("\u6210\u5458\u4e0d\u5b58\u5728");
                return result;
            }
            List<String> teamUserIds = NetworkTeamMemberCache.loadNetworkTeamMemberBy(teamId, "1");
            List diffentUids = (List)CollectionUtil.getDiffent(teamUserIds, addUids = Arrays.asList(uids = userIds.split(",")));
            if (diffentUids.size() > 0) {
                for (int i = 0; i < diffentUids.size(); ++i) {
                    String uid = (String)diffentUids.get(i);
                    if (addUids.contains(uid)) {
                        this.addMember(ctx, teamId, uid);
                        continue;
                    }
                    if (!teamUserIds.contains(uid)) continue;
                    this.removeMember(teamId, uid);
                }
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        if (!UtilString.isEmpty((String)errMsg.toString())) {
            result.err(errMsg.toString());
        }
        return result;
    }

    public void addMember(UserContext ctx, String teamId, String userId) {
        NetworkTeamMemberModel model = new NetworkTeamMemberModel();
        model.setId(UUIDGener.getUUID());
        model.setTeamId(teamId);
        model.setUserId(userId);
        model.setJoinType("1");
        model.setMemberType("2");
        model.setMemberStatus("1");
        model.setCreateUserId(ctx.getUID());
        model.setCreateUserName(ctx.getUserName());
        model.setLastActive(new Timestamp(System.currentTimeMillis()));
        model.setJoinStatus("2");
        NetworkTeamMemberCache.putModel(model);
    }

    public void removeMember(String teamId, String userId) {
        NetworkTeamMemberModel model = NetworkTeamMemberCache.getModel(teamId, userId);
        if (model != null) {
            NetworkTeamMemberCache.removeById(model.getId());
        }
    }
}

