/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.profile;

import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.client.profile.AppUserContent;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicProfile
implements AppUserContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicProfile.class);

    public String getHome(UserContext ctx, String userId, Map<String, Boolean> permMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sid", ctx.getSessionId());
        result.put("uid", ctx.getUID());
        result.put("userId", userId);
        result.put("streamType", "");
        AppAPI appApi = SDK.getAppAPI();
        AppContext favoriteApp = appApi.getAppContext("com.actionsoft.apps.favorite");
        boolean favoriteActive = false;
        if (favoriteApp != null && appApi.isActive(favoriteApp.getId())) {
            favoriteActive = true;
        }
        result.put("isFavoriteActive", favoriteActive);
        String storeMyDriver = appApi.getProperty("com.actionsoft.apps.network", "storeMyDriver");
        boolean existMydriverApp = false;
        if (!UtilString.isEmpty((String)storeMyDriver)) {
            try {
                existMydriverApp = Boolean.parseBoolean(storeMyDriver);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        if (existMydriverApp) {
            AppContext mydriverApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.mydriver");
            existMydriverApp = mydriverApp != null && appApi.isActive(mydriverApp.getId());
        }
        result.put("existMydriverApp", existMydriverApp);
        String isShowSource = appApi.getProperty("com.actionsoft.apps.network", "isShowSource");
        result.put("isShowSource", isShowSource);
        String titleBgColor = appApi.getProperty("com.actionsoft.apps.network", "titleBgColor");
        result.put("titleBgColor", titleBgColor);
        result.put("supportType", NetworkDataUtil.getSupportType(ctx));
        return HtmlPageTemplate.merge((String)"com.actionsoft.apps.network", (String)"network.dynamic.html", result);
    }

    public boolean isSupport(UserContext ctx, String userId, Map<String, Boolean> permMap) {
        return true;
    }
}

