/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryNetworks
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryNetworks.class);

    @Meta(parameter={})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            List<NetworkModel> networkList = NetworkCache.loadNetworkBy(ctx.getUID());
            JSONArray networks = NetworkDataUtil.network2JSON(networkList, ctx);
            ro.put("networks", (Object)networks);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

